/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class representation
extends JPanel {
    static final float[] dash1 = new float[]{10.0f};
    Color[] palette = new Color[]{Color.blue, Color.green, Color.red, Color.cyan, Color.magenta, Color.black, Color.orange, Color.yellow, Color.gray, Color.darkGray, Color.lightGray};
    public sunPath[] allLines = new sunPath[10];
    public int numLines = 0;
    static int MAX_PAINTED_LINES = 10;

    public void recordRepresentation(int day, int month, int year, double lon, double lat, double orto, double ocaso) {
        if (this.numLines < MAX_PAINTED_LINES) {
            this.allLines[this.numLines] = new sunPath(day, month, year, lon, lat, orto, ocaso, this.palette[this.numLines % 11]);
            ++this.numLines;
        }
    }

    public void deleteRepresentations() {
        this.allLines = null;
        this.numLines = 0;
        this.allLines = new sunPath[10];
    }

    public void addPointLastRecord(Point2D p) {
        if (this.numLines < MAX_PAINTED_LINES) {
            this.allLines[this.numLines - 1].addP(p);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File("images/background.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (img != null) {
            g2.drawImage((Image)img, 0, 0, null);
        }
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
        g2.setColor(Color.black);
        g2.setBackground(Color.white);
        g2.setColor(Color.lightGray);
        Line2D.Double height = new Line2D.Double(10.0, 20.0, 10.0, 350.0);
        g2.draw(height);
        g2.drawString("heigth on the horizon (degrees)", 15, 20);
        g2.drawString("90\u00ba", 15, 70);
        g2.drawString("75\u00ba", 15, 120);
        g2.drawString("60\u00ba", 15, 170);
        g2.drawString("45\u00ba", 15, 220);
        g2.drawString("30\u00ba", 15, 270);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(2.0f));
        Line2D.Double horizon = new Line2D.Double(10.0, 340.0, 780.0, 340.0);
        g2.draw(horizon);
        g2.setStroke(new BasicStroke(1.0f));
        int x = 15;
        int h = 0;
        int i = 0;
        while (i < 24) {
            Line2D.Double mark = new Line2D.Double(x, 338.0, x, 342.0);
            g2.draw(mark);
            g2.drawString(Integer.toString(h), x, 355);
            x += 32;
            ++h;
            ++i;
        }
        g2.setColor(Color.lightGray);
        g2.drawString("time (h)", 740, 335);
        i = 0;
        while (i < this.numLines) {
            g2.setColor(this.allLines[i].colour);
            int k = 0;
            while (k < this.allLines[i].nPoints - 1) {
                Line2D.Double line = new Line2D.Double(this.allLines[i].points[k].getX(), this.allLines[i].points[k].getY(), this.allLines[i].points[k + 1].getX(), this.allLines[i].points[k + 1].getY());
                g2.draw(line);
                ++k;
            }
            ++i;
        }
        g2.setColor(Color.black);
        Rectangle2D.Double legend = new Rectangle2D.Double(590.0, 10.0, 180.0, this.numLines * 16);
        g2.setPaint(new Color(240, 240, 240));
        g2.fill(legend);
        int i2 = 0;
        while (i2 < this.numLines) {
            g2.setColor(this.allLines[i2].colour);
            Line2D.Double mark = new Line2D.Double(605.0, 25 + i2 * 15, 635.0, 25 + i2 * 15);
            g2.draw(mark);
            g2.setColor(Color.black);
            g2.drawString(this.allLines[i2].name, 645, 25 + i2 * 15);
            ++i2;
        }
    }

    class sunPath {
        public String name;
        public double orto;
        public double ocaso;
        public Color colour;
        public Point2D.Double[] points;
        public int nPoints;

        public sunPath(int day, int month, int year, double lon, double lat, double orto, double ocaso, Color value) {
            this.name = String.valueOf(Integer.toString(day)) + "/" + Integer.toString(month) + "/" + Integer.toString(year) + " at " + Double.toString(lon) + "_" + Double.toString(lat).substring(0, 4);
            this.orto = orto;
            this.ocaso = ocaso;
            this.colour = value;
            this.points = new Point2D.Double[100];
            this.nPoints = 0;
        }

        public void addP(Point2D p) {
            this.points[this.nPoints] = new Point2D.Double(p.getX(), p.getY());
            ++this.nPoints;
        }
    }
}

