/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CSVPrinter;
import java.io.IOException;
import java.lang.reflect.Array;

public final class ArrayHelper {
    public static Object[] cat(Object[] arr1, Object[] arr2) {
        Class commonSuperClass = Object.class;
        boolean foundcommonSuperClass = false;
        Class<?> c1 = arr1.getClass().getComponentType();
        while (!foundcommonSuperClass && !c1.equals(Object.class)) {
            Class<?> c2 = arr2.getClass().getComponentType();
            while (!foundcommonSuperClass && !c2.equals(Object.class)) {
                if (c2.equals(c1)) {
                    foundcommonSuperClass = true;
                    commonSuperClass = c1;
                }
                c2 = c2.getSuperclass();
            }
            c1 = c1.getSuperclass();
        }
        Object[] result = (Object[])Array.newInstance(commonSuperClass, arr1.length + arr2.length);
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    public static void print(Object[] arr) {
        try {
            CSVPrinter csvp = new CSVPrinter(System.out);
            for (Object element : arr) {
                csvp.write(element.toString());
            }
            csvp.writeln();
            csvp.flush();
        }
        catch (IOException iox) {
            iox.printStackTrace(System.err);
        }
    }

    public static boolean equal(Object[] arr1, Object[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (ArrayHelper.equalObjects(arr1[i], arr2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equalObjects(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

