/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.Base64DecodingException;
import com.Ostermiller.util.CmdLn;
import com.Ostermiller.util.CmdLnOption;
import com.Ostermiller.util.CmdLnResult;
import com.Ostermiller.util.FileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Base64 {
    private static final int END_OF_INPUT = -1;
    private static final int NON_BASE_64 = -1;
    private static final int NON_BASE_64_WHITESPACE = -2;
    private static final int NON_BASE_64_PADDING = -3;
    protected static final byte[] base64Chars;
    protected static final byte[] reverseBase64Chars;
    public static final String version = "1.2";
    protected static ResourceBundle labels;
    private static final int ACTION_GUESS = 0;
    private static final int ACTION_ENCODE = 1;
    private static final int ACTION_DECODE = 2;
    private static final int ARGUMENT_GUESS = 0;
    private static final int ARGUMENT_STRING = 1;
    private static final int ARGUMENT_FILE = 2;

    private Base64() {
    }

    public static void main(String[] args) {
        CmdLn commandLine = new CmdLn(args).setDescription(labels.getString("base64") + labels.getString("purpose.message"));
        for (Base64CmdLnOption option : Base64CmdLnOption.values()) {
            commandLine.addOption(option.getCmdLineOption());
        }
        int action = 0;
        String extension = "base64";
        boolean force = false;
        boolean printMessages = true;
        boolean printErrors = true;
        boolean forceDecode = false;
        boolean lineBreaks = true;
        int argumentType = 0;
        boolean decodeEndLine = false;
        for (CmdLnResult result : commandLine.getResults()) {
            switch ((Base64CmdLnOption)((Object)result.getOption().getUserObject())) {
                case HELP: {
                    commandLine.printHelp();
                    System.exit(0);
                    break;
                }
                case VERSION: {
                    System.out.println(MessageFormat.format(labels.getString("version"), version));
                    System.exit(0);
                    break;
                }
                case ABOUT: {
                    System.out.println(labels.getString("base64") + " -- " + labels.getString("purpose.message") + "\n" + MessageFormat.format(labels.getString("copyright"), "2001-2007", "Stephen Ostermiller (http://ostermiller.org/contact.pl?regarding=Java+Utilities)") + "\n\n" + labels.getString("license"));
                    System.exit(0);
                    break;
                }
                case DECODE: {
                    action = 2;
                    break;
                }
                case DECODEALL: {
                    forceDecode = true;
                    break;
                }
                case DECODEGOOD: {
                    forceDecode = false;
                    break;
                }
                case ENCODE: {
                    action = 1;
                    break;
                }
                case LINES: {
                    lineBreaks = true;
                    break;
                }
                case NOLINES: {
                    lineBreaks = false;
                    break;
                }
                case GUESS: {
                    action = 0;
                    break;
                }
                case EXT: {
                    extension = result.getArgument();
                    if (extension != null) break;
                    extension = "";
                    break;
                }
                case FORCE: {
                    force = true;
                    break;
                }
                case NOFORCE: {
                    force = false;
                    break;
                }
                case VERBOSE: {
                    printMessages = true;
                    printErrors = true;
                    break;
                }
                case QUIET: {
                    printMessages = false;
                    printErrors = true;
                    break;
                }
                case REALLYQUIET: {
                    printMessages = false;
                    printErrors = false;
                    break;
                }
                case FILE: {
                    argumentType = 2;
                    break;
                }
                case STRING: {
                    argumentType = 1;
                    break;
                }
                case ENDLINE: {
                    decodeEndLine = true;
                    break;
                }
                case NOENDLINE: {
                    decodeEndLine = false;
                }
            }
        }
        int exitCond = 0;
        boolean done = false;
        for (String argument : commandLine.getNonOptionArguments()) {
            done = true;
            File source = new File(argument);
            if (argumentType == 1 || argumentType == 0 && !source.exists()) {
                try {
                    int fileAction = action;
                    if (fileAction == 0) {
                        fileAction = Base64.isBase64(argument) ? 2 : 1;
                    }
                    if (fileAction == 1) {
                        if (printMessages) {
                            System.out.println(labels.getString("encodingarg"));
                        }
                        Base64.encode(new ByteArrayInputStream(argument.getBytes()), System.out, lineBreaks);
                        continue;
                    }
                    if (printMessages) {
                        System.out.println(labels.getString("decodingarg"));
                    }
                    Base64.decode(new ByteArrayInputStream(argument.getBytes()), System.out, !forceDecode);
                    if (!decodeEndLine) continue;
                    System.out.println();
                }
                catch (Base64DecodingException x) {
                    if (printErrors) {
                        System.err.println(argument + ": " + x.getMessage() + " " + labels.getString("unexpectedcharforce"));
                    }
                    exitCond = 1;
                }
                catch (IOException x) {
                    if (printErrors) {
                        System.err.println(argument + ": " + x.getMessage());
                    }
                    exitCond = 1;
                }
                continue;
            }
            if (!source.exists()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("doesnotexist"), argument));
                }
                exitCond = 1;
                continue;
            }
            if (!source.canRead()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("cantread"), argument));
                }
                exitCond = 1;
                continue;
            }
            try {
                int fileAction = action;
                if (fileAction == 0) {
                    fileAction = Base64.isBase64(source) ? 2 : 1;
                }
                String outName = argument;
                if (extension.length() > 0) {
                    if (fileAction == 1) {
                        outName = argument + "." + extension;
                    } else if (argument.endsWith("." + extension)) {
                        outName = argument.substring(0, argument.length() - (extension.length() + 1));
                    }
                }
                File outFile = new File(outName);
                if (!force && outFile.exists()) {
                    if (printErrors) {
                        System.err.println(MessageFormat.format(labels.getString("overwrite"), outName));
                    }
                    exitCond = 1;
                    continue;
                }
                if (!outFile.exists() && !outFile.createNewFile() || !outFile.canWrite()) {
                    if (printErrors) {
                        System.err.println(MessageFormat.format(labels.getString("cantwrite"), outName));
                    }
                    exitCond = 1;
                    continue;
                }
                if (fileAction == 1) {
                    if (printMessages) {
                        System.out.println(MessageFormat.format(labels.getString("encoding"), argument, outName));
                    }
                    Base64.encode(source, outFile, lineBreaks);
                    continue;
                }
                if (printMessages) {
                    System.out.println(MessageFormat.format(labels.getString("decoding"), argument, outName));
                }
                Base64.decode(source, outFile, !forceDecode);
            }
            catch (Base64DecodingException x) {
                if (printErrors) {
                    System.err.println(argument + ": " + x.getMessage() + " " + labels.getString("unexpectedcharforce"));
                }
                exitCond = 1;
            }
            catch (IOException x) {
                if (printErrors) {
                    System.err.println(argument + ": " + x.getMessage());
                }
                exitCond = 1;
            }
        }
        if (!done) {
            try {
                if (action == 0) {
                    if (printErrors) {
                        System.err.println(labels.getString("cantguess"));
                    }
                    exitCond = 1;
                } else if (action == 1) {
                    Base64.encode(new BufferedInputStream(System.in), new BufferedOutputStream(System.out), lineBreaks);
                } else {
                    Base64.decode(new BufferedInputStream(System.in), new BufferedOutputStream(System.out), !forceDecode);
                    if (decodeEndLine) {
                        System.out.println();
                    }
                }
            }
            catch (Base64DecodingException x) {
                if (printErrors) {
                    System.err.println(x.getMessage() + " " + labels.getString("unexpectedcharforce"));
                }
                exitCond = 1;
            }
            catch (IOException x) {
                if (printErrors) {
                    System.err.println(x.getMessage());
                }
                exitCond = 1;
            }
        }
        System.exit(exitCond);
    }

    public static String encode(String string) {
        return new String(Base64.encode(string.getBytes()));
    }

    public static String encode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64.encode(string.getBytes(enc)), enc);
    }

    public static String encodeToString(byte[] bytes) {
        return Base64.encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean lineBreaks) {
        try {
            return new String(Base64.encode(bytes, lineBreaks), "ASCII");
        }
        catch (UnsupportedEncodingException iex) {
            throw new RuntimeException(iex);
        }
    }

    public static byte[] encode(byte[] bytes) {
        return Base64.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean lineBreaks) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 3;
        if (mod != 0) {
            length += 3 - mod;
        }
        length = length * 4 / 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64.encode(in, out, lineBreaks);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public static void encode(File fIn) throws IOException {
        Base64.encode(fIn, fIn, true);
    }

    public static void encode(File fIn, boolean lineBreaks) throws IOException {
        Base64.encode(fIn, fIn, lineBreaks);
    }

    public static void encode(File fIn, File fOut) throws IOException {
        Base64.encode(fIn, fOut, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(File fIn, File fOut, boolean lineBreaks) throws IOException {
        File temp = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fIn));
            temp = File.createTempFile("Base64", null, null);
            out = new BufferedOutputStream(new FileOutputStream(temp));
            Base64.encode(in, out, lineBreaks);
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;
            FileHelper.move(temp, fOut, true);
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        Base64.encode(in, out, true);
    }

    public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
        int[] inBuffer = new int[3];
        int lineCount = 0;
        boolean done = false;
        while (!done && (inBuffer[0] = in.read()) != -1) {
            inBuffer[1] = in.read();
            inBuffer[2] = in.read();
            out.write(base64Chars[inBuffer[0] >> 2]);
            if (inBuffer[1] != -1) {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                if (inBuffer[2] != -1) {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                    out.write(base64Chars[inBuffer[2] & 0x3F]);
                } else {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C]);
                    out.write(61);
                    done = true;
                }
            } else {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30]);
                out.write(61);
                out.write(61);
                done = true;
            }
            if (!lineBreaks || (lineCount += 4) < 76) continue;
            out.write(10);
            lineCount = 0;
        }
        if (lineBreaks && lineCount >= 1) {
            out.write(10);
            lineCount = 0;
        }
        out.flush();
    }

    public static String decode(String string) {
        return new String(Base64.decode(string.getBytes()));
    }

    public static String decode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64.decode(string.getBytes(enc)), enc);
    }

    public static String decode(String string, String encIn, String encOut) throws UnsupportedEncodingException {
        return new String(Base64.decode(string.getBytes(encIn)), encOut);
    }

    public static String decodeToString(String string) {
        return new String(Base64.decode(string.getBytes()));
    }

    public static String decodeToString(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64.decode(string.getBytes(enc)), enc);
    }

    public static String decodeToString(String string, String encIn, String encOut) throws UnsupportedEncodingException {
        return new String(Base64.decode(string.getBytes(encIn)), encOut);
    }

    public static void decodeToStream(String string, OutputStream out) throws IOException {
        Base64.decode(new ByteArrayInputStream(string.getBytes()), out);
    }

    public static void decodeToStream(String string, String enc, OutputStream out) throws UnsupportedEncodingException, IOException {
        Base64.decode(new ByteArrayInputStream(string.getBytes(enc)), out);
    }

    public static byte[] decodeToBytes(String string) {
        return Base64.decode(string.getBytes());
    }

    public static byte[] decodeToBytes(String string, String enc) throws UnsupportedEncodingException {
        return Base64.decode(string.getBytes(enc));
    }

    public static String decodeToString(byte[] bytes) {
        return new String(Base64.decode(bytes));
    }

    public static String decodeToString(byte[] bytes, String enc) throws UnsupportedEncodingException {
        return new String(Base64.decode(bytes), enc);
    }

    public static byte[] decodeToBytes(byte[] bytes) {
        return Base64.decode(bytes);
    }

    public static byte[] decode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 4;
        if (mod != 0) {
            length += 4 - mod;
        }
        length = length * 3 / 4;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64.decode(in, out, false);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public static void decode(byte[] bytes, OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Base64.decode(in, out, false);
    }

    public static void decodeToStream(byte[] bytes, OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Base64.decode(in, out, false);
    }

    public static void decode(File fIn) throws IOException {
        Base64.decode(fIn, fIn, true);
    }

    public static void decode(File fIn, boolean throwExceptions) throws IOException {
        Base64.decode(fIn, fIn, throwExceptions);
    }

    public static void decode(File fIn, File fOut) throws IOException {
        Base64.decode(fIn, fOut, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(File fIn, File fOut, boolean throwExceptions) throws IOException {
        File temp = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fIn));
            temp = File.createTempFile("Base64", null, null);
            out = new BufferedOutputStream(new FileOutputStream(temp));
            Base64.decode(in, out, throwExceptions);
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;
            FileHelper.move(temp, fOut, true);
        }
        finally {
            if (in != null) {
                block14: {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        if (!throwExceptions) break block14;
                        throw ignore;
                    }
                }
                in = null;
            }
            if (out != null) {
                block15: {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ignore) {
                        if (!throwExceptions) break block15;
                        throw ignore;
                    }
                }
                out = null;
            }
        }
    }

    private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
        int read;
        int numPadding = 0;
        do {
            if ((read = in.read()) == -1) {
                return -1;
            }
            read = reverseBase64Chars[(byte)read];
            if (throwExceptions && (read == -1 || numPadding > 0 && read > -1)) {
                throw new Base64DecodingException(MessageFormat.format(labels.getString("unexpectedchar"), "'" + (char)read + "' (0x" + Integer.toHexString(read) + ")"), (char)read);
            }
            if (read != -3) continue;
            ++numPadding;
        } while (read <= -1);
        return read;
    }

    public static byte[] decodeToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64.decode(in, out, false);
        return out.toByteArray();
    }

    public static String decodeToString(InputStream in) throws IOException {
        return new String(Base64.decodeToBytes(in));
    }

    public static String decodeToString(InputStream in, String enc) throws IOException {
        return new String(Base64.decodeToBytes(in), enc);
    }

    public static void decode(InputStream in, OutputStream out) throws IOException {
        Base64.decode(in, out, true);
    }

    public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
        int[] inBuffer = new int[4];
        boolean done = false;
        while (!done && (inBuffer[0] = Base64.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = Base64.readBase64(in, throwExceptions)) != -1) {
            inBuffer[2] = Base64.readBase64(in, throwExceptions);
            inBuffer[3] = Base64.readBase64(in, throwExceptions);
            out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
            if (inBuffer[2] != -1) {
                out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                if (inBuffer[3] != -1) {
                    out.write(inBuffer[2] << 6 | inBuffer[3]);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        out.flush();
    }

    public static boolean isBase64(byte[] bytes) {
        try {
            return Base64.isBase64(new ByteArrayInputStream(bytes));
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean isBase64(String string) {
        return Base64.isBase64(string.getBytes());
    }

    public static boolean isBase64(String string, String enc) throws UnsupportedEncodingException {
        return Base64.isBase64(string.getBytes(enc));
    }

    public static boolean isBase64(File fIn) throws IOException {
        return Base64.isBase64(new BufferedInputStream(new FileInputStream(fIn)));
    }

    public static boolean isBase64(InputStream in) throws IOException {
        int read;
        long numBase64Chars = 0L;
        int numPadding = 0;
        while ((read = in.read()) != -1) {
            if ((read = reverseBase64Chars[read]) == -1) {
                return false;
            }
            if (read == -2) continue;
            if (read == -3) {
                ++numPadding;
                ++numBase64Chars;
                continue;
            }
            if (numPadding > 0) {
                return false;
            }
            ++numBase64Chars;
        }
        if (numBase64Chars == 0L) {
            return false;
        }
        return numBase64Chars % 4L == 0L;
    }

    static {
        int i;
        base64Chars = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        reverseBase64Chars = new byte[256];
        for (i = 0; i < reverseBase64Chars.length; ++i) {
            Base64.reverseBase64Chars[i] = -1;
        }
        for (i = 0; i < base64Chars.length; i = (int)((byte)(i + 1))) {
            Base64.reverseBase64Chars[Base64.base64Chars[i]] = i;
        }
        Base64.reverseBase64Chars[32] = -2;
        Base64.reverseBase64Chars[10] = -2;
        Base64.reverseBase64Chars[13] = -2;
        Base64.reverseBase64Chars[9] = -2;
        Base64.reverseBase64Chars[12] = -2;
        Base64.reverseBase64Chars[61] = -3;
        labels = ResourceBundle.getBundle("com.Ostermiller.util.Base64", Locale.getDefault());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Base64CmdLnOption {
        HELP(new CmdLnOption(labels.getString("help.option")).setDescription(labels.getString("help.message"))),
        VERSION(new CmdLnOption(labels.getString("version.option")).setDescription(labels.getString("version.message"))),
        ABOUT(new CmdLnOption(labels.getString("about.option")).setDescription(labels.getString("about.message"))),
        GUESS(new CmdLnOption(labels.getString("guess.option"), Character.valueOf('g')).setDescription(labels.getString("g.message") + " (" + labels.getString("default") + ")")),
        ENCODE(new CmdLnOption(labels.getString("encode.option"), Character.valueOf('e')).setDescription(labels.getString("e.message"))),
        LINES(new CmdLnOption(labels.getString("lines.option"), Character.valueOf('l')).setDescription(labels.getString("l.message") + " (" + labels.getString("default") + ")")),
        NOLINES(new CmdLnOption(labels.getString("nolines.option")).setDescription(labels.getString("nolines.message"))),
        DECODE(new CmdLnOption(labels.getString("decode.option"), Character.valueOf('d')).setDescription(labels.getString("d.message"))),
        DECODEALL(new CmdLnOption(labels.getString("decodeall.option"), Character.valueOf('a')).setDescription(labels.getString("a.message"))),
        DECODEGOOD(new CmdLnOption(labels.getString("decodegood.option")).setDescription(labels.getString("decodegood.message") + " (" + labels.getString("default") + ")")),
        EXT(new CmdLnOption(labels.getString("ext.option"), Character.valueOf('x')).setOptionalArgument().setDescription(labels.getString("x.message"))),
        FORCE(new CmdLnOption(labels.getString("force.option"), Character.valueOf('f')).setDescription(labels.getString("f.message"))),
        NOFORCE(new CmdLnOption(labels.getString("noforce.option")).setDescription(labels.getString("noforce.message") + " (" + labels.getString("default") + ")")),
        VERBOSE(new CmdLnOption(labels.getString("verbose.option"), Character.valueOf('v')).setDescription(labels.getString("v.message") + " (" + labels.getString("default") + ")")),
        QUIET(new CmdLnOption(labels.getString("quiet.option"), Character.valueOf('q')).setDescription(labels.getString("q.message"))),
        REALLYQUIET(new CmdLnOption(labels.getString("reallyquiet.option"), Character.valueOf('Q')).setDescription(labels.getString("Q.message"))),
        FILE(new CmdLnOption(labels.getString("file.option")).setDescription(labels.getString("file.message"))),
        STRING(new CmdLnOption(labels.getString("string.option")).setDescription(labels.getString("string.message"))),
        ENDLINE(new CmdLnOption(labels.getString("newline.option"), Character.valueOf('n')).setDescription(labels.getString("newline.message"))),
        NOENDLINE(new CmdLnOption(labels.getString("nonewline.option")).setDescription(labels.getString("nonewline.message")));

        private CmdLnOption option;

        private Base64CmdLnOption(CmdLnOption option) {
            option.setUserObject((Object)this);
            this.option = option;
        }

        private CmdLnOption getCmdLineOption() {
            return this.option;
        }
    }
}

