/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class ConcatReader
extends Reader {
    private int readerQueueIndex = 0;
    private ArrayList<Reader> readerQueue = new ArrayList();
    private Reader currentReader = null;
    private boolean doneAddingReaders = false;
    private boolean closed = false;

    public void lastReaderAdded() {
        this.doneAddingReaders = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReader(Reader in) {
        ArrayList<Reader> arrayList = this.readerQueue;
        synchronized (arrayList) {
            if (in == null) {
                throw new NullPointerException();
            }
            if (this.closed) {
                throw new IllegalStateException("ConcatReader has been closed");
            }
            if (this.doneAddingReaders) {
                throw new IllegalStateException("Cannot add more readers - the last reader has already been added.");
            }
            this.readerQueue.add(in);
        }
    }

    public void addReaders(Reader[] in) {
        for (Reader element : in) {
            this.addReader(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getCurrentReader() {
        if (this.currentReader == null && this.readerQueueIndex < this.readerQueue.size()) {
            ArrayList<Reader> arrayList = this.readerQueue;
            synchronized (arrayList) {
                this.currentReader = this.readerQueue.get(this.readerQueueIndex);
            }
        }
        return this.currentReader;
    }

    private void advanceToNextReader() {
        this.currentReader = null;
        ++this.readerQueueIndex;
    }

    public ConcatReader() {
    }

    public ConcatReader(Reader in) {
        this.addReader(in);
        this.lastReaderAdded();
    }

    public ConcatReader(Reader in1, Reader in2) {
        this.addReader(in1);
        this.addReader(in2);
        this.lastReaderAdded();
    }

    public ConcatReader(Reader[] in) {
        this.addReaders(in);
        this.lastReaderAdded();
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        int r = -1;
        while (r == -1) {
            Reader in = this.getCurrentReader();
            if (in == null) {
                if (this.doneAddingReaders) {
                    return -1;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            r = in.read();
            if (r != -1) continue;
            this.advanceToNextReader();
        }
        return r;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        int r = -1;
        while (r == -1) {
            Reader in = this.getCurrentReader();
            if (in == null) {
                if (this.doneAddingReaders) {
                    return -1;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            r = in.read(cbuf, off, len);
            if (r != -1) continue;
            this.advanceToNextReader();
        }
        return r;
    }

    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        long s = -1L;
        while (s <= 0L) {
            Reader in = this.getCurrentReader();
            if (in == null) {
                if (this.doneAddingReaders) {
                    return 0L;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iox) {
                    throw new IOException("Interrupted");
                }
            }
            s = in.skip(n);
            if (s > 0L) continue;
            s = this.read() == -1 ? -1 : 1;
        }
        return s;
    }

    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        Reader in = this.getCurrentReader();
        if (in == null) {
            return false;
        }
        return in.ready();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        for (Reader reader : this.readerQueue) {
            reader.close();
        }
        this.closed = true;
    }

    public void mark(int readlimit) throws IOException {
        throw new IOException("Mark not supported");
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

