/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVParse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LabeledCSVParser
implements CSVParse {
    private CSVParse parse;
    private String[] labels;
    private Map<String, Integer> labelMap;
    private String[] lastLine;
    private int nextValueLine = -2;

    public LabeledCSVParser(CSVParse parse) throws IOException {
        this.parse = parse;
    }

    public void changeDelimiter(char newDelim) throws BadDelimiterException {
        this.parse.changeDelimiter(newDelim);
    }

    public void changeQuote(char newQuote) throws BadQuoteException {
        this.parse.changeQuote(newQuote);
    }

    public String[][] getAllValues() throws IOException {
        String[][] allValues;
        if (this.labels == null) {
            this.setLabels();
        }
        this.lastLine = (allValues = this.parse.getAllValues()) == null ? null : allValues[allValues.length - 1];
        return allValues;
    }

    public int getLastLineNumber() {
        return this.lastLineNumber();
    }

    public int lastLineNumber() {
        int lineNum = this.parse.getLastLineNumber();
        if (lineNum <= -1) {
            return -1;
        }
        if (lineNum == 1) {
            return -1;
        }
        return lineNum - 1;
    }

    public String[] getLine() throws IOException {
        if (this.labels == null) {
            this.setLabels();
        }
        this.lastLine = this.parse.getLine();
        return this.lastLine;
    }

    public String nextValue() throws IOException {
        if (this.labels == null) {
            this.setLabels();
        }
        String nextValue = this.parse.nextValue();
        this.nextValueLine = this.getLastLineNumber();
        return nextValue;
    }

    private void setLabels() throws IOException {
        this.labels = this.parse.getLine();
        if (this.labels == null) {
            return;
        }
        this.labelMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.labels.length; ++i) {
            this.labelMap.put(this.labels[i], new Integer(i));
        }
    }

    public String[] getLabels() throws IOException {
        if (this.labels == null) {
            this.setLabels();
        }
        return this.labels;
    }

    @Deprecated
    public int getLabelIndex(String label) {
        try {
            return this.getLabelIdx(label);
        }
        catch (IOException iox) {
            return -1;
        }
    }

    public int getLabelIdx(String label) throws IOException {
        if (this.labels == null) {
            this.setLabels();
        }
        if (this.labelMap == null) {
            return -1;
        }
        if (!this.labelMap.containsKey(label)) {
            return -1;
        }
        return this.labelMap.get(label);
    }

    public String getValueByLabel(String label) throws IllegalStateException {
        int fieldIndex;
        if (this.nextValueLine == this.getLastLineNumber()) {
            throw new IllegalStateException("nextValue() was used to get values from this line.");
        }
        if (this.lastLine == null) {
            return null;
        }
        try {
            fieldIndex = this.getLabelIdx(label);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        if (fieldIndex == -1) {
            return null;
        }
        if (fieldIndex >= this.lastLine.length) {
            return null;
        }
        return this.lastLine[fieldIndex];
    }

    public void close() throws IOException {
        this.parse.close();
    }
}

