/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BinaryDataException;
import com.Ostermiller.util.CmdLn;
import com.Ostermiller.util.CmdLnOption;
import com.Ostermiller.util.CmdLnResult;
import com.Ostermiller.util.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class LineEnds {
    public static final String version = "1.2";
    protected static ResourceBundle labels = ResourceBundle.getBundle("com.Ostermiller.util.LineEnds", Locale.getDefault());
    public static final int STYLE_SYSTEM = 0;
    public static final int STYLE_WINDOWS = 1;
    public static final int STYLE_DOS = 1;
    public static final int STYLE_RN = 1;
    public static final int STYLE_UNIX = 2;
    public static final int STYLE_N = 2;
    public static final int STYLE_JAVA = 2;
    public static final int STYLE_MAC = 3;
    public static final int STYLE_R = 3;
    private static final int BUFFER_SIZE = 1024;
    private static final int STATE_INIT = 0;
    private static final int STATE_R = 1;
    private static final int MASK_N = 1;
    private static final int MASK_R = 2;
    private static final int MASK_RN = 4;

    public static void main(String[] args) {
        CmdLn commandLine = new CmdLn(args).setDescription(labels.getString("lineends") + labels.getString("purpose.message"));
        for (LineEndsCmdLnOption option : LineEndsCmdLnOption.values()) {
            commandLine.addOption(option.getCmdLineOption());
        }
        int style = 0;
        boolean force = false;
        boolean printMessages = false;
        boolean printExtraMessages = false;
        boolean printErrors = true;
        for (CmdLnResult result : commandLine.getResults()) {
            switch ((LineEndsCmdLnOption)((Object)result.getOption().getUserObject())) {
                case HELP: {
                    commandLine.printHelp();
                    System.exit(0);
                    break;
                }
                case VERSION: {
                    System.out.println(MessageFormat.format(labels.getString("version"), version));
                    System.exit(0);
                    break;
                }
                case ABOUT: {
                    System.out.println(labels.getString("lineends") + " -- " + labels.getString("purpose.message") + "\n" + MessageFormat.format(labels.getString("copyright"), "2001", "Stephen Ostermiller (http://ostermiller.org/contact.pl?regarding=Java+Utilities)") + "\n\n" + labels.getString("license"));
                    System.exit(0);
                    break;
                }
                case DOS: {
                    style = 1;
                    break;
                }
                case UNIX: {
                    style = 2;
                    break;
                }
                case MAC: {
                    style = 3;
                    break;
                }
                case SYSTEM: {
                    style = 0;
                    break;
                }
                case FORCE: {
                    force = true;
                    break;
                }
                case NOFORCE: {
                    force = false;
                    break;
                }
                case REALLYVERBOSE: {
                    printExtraMessages = true;
                    printMessages = true;
                    printErrors = true;
                    break;
                }
                case VERBOSE: {
                    printExtraMessages = false;
                    printMessages = true;
                    printErrors = true;
                    break;
                }
                case QUIET: {
                    printExtraMessages = false;
                    printMessages = false;
                    printErrors = true;
                    break;
                }
                case REALLYQUIET: {
                    printExtraMessages = false;
                    printMessages = false;
                    printErrors = false;
                }
            }
        }
        int exitCond = 0;
        boolean done = false;
        for (String argument : commandLine.getNonOptionArguments()) {
            done = true;
            File source = new File(argument);
            if (!source.exists()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("doesnotexist"), argument));
                }
                exitCond = 1;
                continue;
            }
            if (!source.canRead()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("cantread"), argument));
                }
                exitCond = 1;
                continue;
            }
            if (!source.canWrite()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("cantwrite"), argument));
                }
                exitCond = 1;
                continue;
            }
            try {
                if (LineEnds.convert(source, style, !force)) {
                    if (!printMessages) continue;
                    System.out.println(MessageFormat.format(labels.getString("modified"), argument));
                    continue;
                }
                if (!printExtraMessages) continue;
                System.out.println(MessageFormat.format(labels.getString("alreadycorrect"), argument));
            }
            catch (IOException x) {
                if (printErrors) {
                    System.err.println(argument + ": " + x.getMessage());
                }
                exitCond = 1;
            }
        }
        if (!done) {
            try {
                LineEnds.convert(System.in, System.out, style, !force);
            }
            catch (IOException x) {
                System.err.println(x.getMessage());
                exitCond = 1;
            }
        }
        System.exit(exitCond);
    }

    public static boolean convert(InputStream in, OutputStream out) throws IOException {
        return LineEnds.convert(in, out, 0, true);
    }

    public static boolean convert(InputStream in, OutputStream out, int style) throws IOException {
        return LineEnds.convert(in, out, style, true);
    }

    public static boolean convert(InputStream in, OutputStream out, boolean binaryException) throws IOException {
        return LineEnds.convert(in, out, 0, binaryException);
    }

    public static boolean convert(InputStream in, OutputStream out, int style, boolean binaryException) throws IOException {
        int read;
        byte[] lineEnding;
        switch (style) {
            case 0: {
                lineEnding = System.getProperty("line.separator").getBytes();
                break;
            }
            case 1: {
                lineEnding = new byte[]{13, 10};
                break;
            }
            case 3: {
                lineEnding = new byte[]{13};
                break;
            }
            case 2: {
                lineEnding = new byte[]{10};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown line break style: " + style);
            }
        }
        byte[] buffer = new byte[1024];
        boolean state = false;
        int seen = 0;
        while ((read = in.read(buffer)) != -1) {
            for (int i = 0; i < read; ++i) {
                byte b = buffer[i];
                if (state && b != 10) {
                    out.write(lineEnding);
                    seen |= 2;
                }
                if (b == 13) {
                    state = true;
                    continue;
                }
                if (b == 10) {
                    seen = state ? (seen |= 4) : (seen |= 1);
                    out.write(lineEnding);
                } else {
                    if (binaryException && b != 9 && b != 12 && (b & 0xFF) < 32) {
                        throw new BinaryDataException(labels.getString("binaryexcepion"));
                    }
                    out.write(b);
                }
                state = false;
            }
        }
        if (state) {
            out.write(lineEnding);
            seen |= 2;
        }
        if (lineEnding.length == 2 && lineEnding[0] == 13 && lineEnding[1] == 10) {
            return (seen & 0xFFFFFFFB) != 0;
        }
        if (lineEnding.length == 1 && lineEnding[0] == 13) {
            return (seen & 0xFFFFFFFD) != 0;
        }
        if (lineEnding.length == 1 && lineEnding[0] == 10) {
            return (seen & 0xFFFFFFFE) != 0;
        }
        return true;
    }

    public static boolean convert(File f) throws IOException {
        return LineEnds.convert(f, 0, true);
    }

    public static boolean convert(File f, int style) throws IOException {
        return LineEnds.convert(f, style, true);
    }

    public static boolean convert(File f, boolean binaryException) throws IOException {
        return LineEnds.convert(f, 0, binaryException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convert(File f, int style, boolean binaryException) throws IOException {
        File temp = null;
        FileInputStream in = null;
        OutputStream out = null;
        boolean modified = false;
        try {
            in = new FileInputStream(f);
            temp = File.createTempFile("LineEnds", null, null);
            out = new FileOutputStream(temp);
            modified = LineEnds.convert(in, out, style, binaryException);
            ((InputStream)in).close();
            in = null;
            out.flush();
            out.close();
            out = null;
            if (modified) {
                FileHelper.move(temp, f, true);
            } else if (!temp.delete()) {
                throw new IOException(MessageFormat.format(labels.getString("tempdeleteerror"), temp.toString()));
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
                in = null;
            }
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        return modified;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LineEndsCmdLnOption {
        HELP(new CmdLnOption(labels.getString("help.option")).setDescription(labels.getString("help.message"))),
        VERSION(new CmdLnOption(labels.getString("version.option")).setDescription(labels.getString("version.message"))),
        ABOUT(new CmdLnOption(labels.getString("about.option")).setDescription(labels.getString("about.message"))),
        DOS(new CmdLnOption(new String[]{labels.getString("dos.option"), labels.getString("windows.option")}, new char[]{'d'}).setDescription(labels.getString("d.message"))),
        UNIX(new CmdLnOption(new String[]{labels.getString("unix.option"), labels.getString("java.option")}, new char[]{'n'}).setDescription(labels.getString("n.message"))),
        MAC(new CmdLnOption(labels.getString("mac.option"), Character.valueOf('r')).setDescription(labels.getString("r.message"))),
        SYSTEM(new CmdLnOption(labels.getString("system.option"), Character.valueOf('s')).setDescription(labels.getString("s.message") + " (" + labels.getString("default") + ")")),
        FORCE(new CmdLnOption(labels.getString("force.option"), Character.valueOf('f')).setDescription(labels.getString("f.message"))),
        QUIET(new CmdLnOption(labels.getString("quiet.option"), Character.valueOf('q')).setDescription(labels.getString("q.message") + " (" + labels.getString("default") + ")")),
        REALLYQUIET(new CmdLnOption(labels.getString("reallyquiet.option"), Character.valueOf('Q')).setDescription(labels.getString("Q.message"))),
        VERBOSE(new CmdLnOption(labels.getString("verbose.option"), Character.valueOf('v')).setDescription(labels.getString("v.message"))),
        REALLYVERBOSE(new CmdLnOption(labels.getString("reallyverbose.option"), Character.valueOf('V')).setDescription(labels.getString("V.message"))),
        NOFORCE(new CmdLnOption(labels.getString("noforce.option")).setDescription(labels.getString("noforce.message") + " (" + labels.getString("default") + ")"));

        private CmdLnOption option;

        private LineEndsCmdLnOption(CmdLnOption option) {
            option.setUserObject((Object)this);
            this.option = option;
        }

        private CmdLnOption getCmdLineOption() {
            return this.option;
        }
    }
}

