/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends JDialog {
    private static final long serialVersionUID = -832548326686122133L;
    protected ResourceBundle labels;
    protected JTextField name;
    protected JPasswordField pass;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JLabel nameLabel;
    protected JLabel passLabel;
    private boolean pressed_OK = false;

    public void setLocale(Locale locale) {
        this.labels = ResourceBundle.getBundle("com.Ostermiller.util.PasswordDialog", locale);
    }

    public void setName(String name) {
        this.name.setText(name);
    }

    public void setPass(String pass) {
        this.pass.setText(pass);
    }

    public void setOKText(String ok) {
        this.okButton.setText(ok);
        this.pack();
    }

    public void setCancelText(String cancel) {
        this.cancelButton.setText(cancel);
        this.pack();
    }

    public void setNameLabel(String name) {
        this.nameLabel.setText(name);
        this.pack();
    }

    public void setPassLabel(String pass) {
        this.passLabel.setText(pass);
        this.pack();
    }

    public String getName() {
        return this.name.getText();
    }

    public String getPass() {
        return new String(this.pass.getPassword());
    }

    public boolean okPressed() {
        return this.pressed_OK;
    }

    public PasswordDialog(Frame parent, String title) {
        super(parent, title, true);
        this.setLocale(Locale.getDefault());
        if (title == null) {
            this.setTitle(this.labels.getString("dialog.title"));
        }
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
    }

    public PasswordDialog(Frame parent) {
        this(parent, null);
    }

    public PasswordDialog() {
        this((Frame)null, (String)null);
    }

    protected void dialogInit() {
        if (this.labels == null) {
            this.setLocale(Locale.getDefault());
        }
        this.name = new JTextField("", 20);
        this.pass = new JPasswordField("", 20);
        this.okButton = new JButton(this.labels.getString("dialog.ok"));
        this.cancelButton = new JButton(this.labels.getString("dialog.cancel"));
        this.nameLabel = new JLabel(this.labels.getString("dialog.name") + " ");
        this.passLabel = new JLabel(this.labels.getString("dialog.pass") + " ");
        super.dialogInit();
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getSource() == PasswordDialog.this.cancelButton && e.getKeyCode() == 10) {
                    PasswordDialog.this.pressed_OK = false;
                    PasswordDialog.this.setVisible(false);
                }
                if (e.getSource() == PasswordDialog.this.okButton && e.getKeyCode() == 10) {
                    PasswordDialog.this.pressed_OK = true;
                    PasswordDialog.this.setVisible(false);
                }
            }
        };
        this.addKeyListener(keyListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == PasswordDialog.this.name) {
                    PasswordDialog.this.name.transferFocus();
                } else {
                    PasswordDialog.this.pressed_OK = source == PasswordDialog.this.pass || source == PasswordDialog.this.okButton;
                    PasswordDialog.this.setVisible(false);
                }
            }
        };
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 5;
        c.insets.bottom = 5;
        JPanel pane = new JPanel(gridbag);
        pane.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 20));
        c.anchor = 13;
        gridbag.setConstraints(this.nameLabel, c);
        pane.add(this.nameLabel);
        gridbag.setConstraints(this.name, c);
        this.name.addActionListener(actionListener);
        this.name.addKeyListener(keyListener);
        pane.add(this.name);
        c.gridy = 1;
        gridbag.setConstraints(this.passLabel, c);
        pane.add(this.passLabel);
        gridbag.setConstraints(this.pass, c);
        this.pass.addActionListener(actionListener);
        this.pass.addKeyListener(keyListener);
        pane.add(this.pass);
        c.gridy = 2;
        c.gridwidth = 0;
        c.anchor = 10;
        JPanel panel = new JPanel();
        this.okButton.addActionListener(actionListener);
        this.okButton.addKeyListener(keyListener);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(actionListener);
        this.cancelButton.addKeyListener(keyListener);
        panel.add(this.cancelButton);
        gridbag.setConstraints(panel, c);
        pane.add(panel);
        this.getContentPane().add(pane);
        this.pack();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.okPressed();
    }
}

