/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.vecmath.Vector3d;

public class PhasesOfMoon
implements ActionListener {
    static Animation anim;
    public JFrame MainFrame = new JFrame("Moon Phases General Aplication");
    JTextArea specinfo;
    static JTextArea illum;
    static JTextArea date;
    static JTextArea txto;
    static JTextArea txt2line;
    JLabel photo;
    JTextArea typeOfMoon;
    JTextField GetTxtDay;
    JTextField GetTxtMonth;
    JTextField GetTxtYear;
    JTextArea txtError;
    Timer timer;
    double counter;
    static double position;
    JButton buttonCalc;
    JButton playbutton;
    JButton stopbutton;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhasesOfMoon p = new PhasesOfMoon();
            }
        });
    }

    public PhasesOfMoon() {
        this.MainFrame.setBackground(Color.white);
        this.MainFrame.setDefaultCloseOperation(3);
        this.initPanelInfoAndAnimation();
        this.initPanelData();
        this.MainFrame.pack();
        this.MainFrame.setVisible(true);
        this.counter = 0.0;
        this.timer = new Timer(10, this);
        this.timer.start();
    }

    public void initPanelInfoAndAnimation() {
        JPanel comp = new JPanel(new FlowLayout(1));
        TitledBorder titled = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), "moon phase");
        comp.setBorder(titled);
        comp.setBackground(Color.white);
        comp.setPreferredSize(new Dimension(350, 300));
        JTextArea txtIni = new JTextArea("A lunar phase or phase of the moon is the appearance of the illuminated portion of the Moon as seen by an observer on Earth. The lunar phases change cyclically as the Moon orbits the Earth, according to the changing relative positions of the Earth, Moon, and Sun.");
        txtIni.setEditable(false);
        txtIni.setLineWrap(true);
        txtIni.setWrapStyleWord(true);
        txtIni.setPreferredSize(new Dimension(300, 100));
        comp.add(txtIni);
        JTextArea txt = new JTextArea("Type of Moon:");
        txt.setEditable(false);
        txt.setSize(50, 50);
        comp.add(txt);
        this.typeOfMoon = new JTextArea("NEW MOON");
        this.typeOfMoon.setEditable(false);
        this.typeOfMoon.setSize(100, 50);
        Font font = new Font("Verdana", 1, 12);
        this.typeOfMoon.setFont(font);
        this.typeOfMoon.setForeground(Color.BLUE);
        comp.add(this.typeOfMoon);
        ImageIcon icon = new ImageIcon("images/m_1.png");
        this.photo = new JLabel();
        this.photo.setIcon(icon);
        comp.add(this.photo);
        this.specinfo = new JTextArea("");
        this.specinfo.setEditable(false);
        this.specinfo.setSize(280, 50);
        this.specinfo.setLineWrap(true);
        this.specinfo.setWrapStyleWord(true);
        comp.add(this.specinfo);
        JPanel allinfo = new JPanel(new GridLayout(9, 1));
        allinfo.add(new JTextArea(""));
        illum = new JTextArea("");
        illum.setEditable(false);
        illum.setSize(100, 50);
        allinfo.add(illum);
        allinfo.add(new JTextArea(""));
        date = new JTextArea("");
        Font font2 = new Font("Verdana", 1, 10);
        date.setFont(font2);
        date.setEditable(false);
        date.setSize(100, 50);
        allinfo.add(date);
        allinfo.add(new JTextArea(""));
        txto = new JTextArea("");
        txto.setEditable(false);
        txto.setSize(100, 50);
        allinfo.add(txto);
        allinfo.add(new JTextArea(""));
        txt2line = new JTextArea("");
        txt2line.setEditable(false);
        txt2line.setSize(100, 50);
        allinfo.add(txt2line);
        allinfo.add(new JTextArea(""));
        comp.add(allinfo);
        this.MainFrame.getContentPane().add((Component)comp, "West");
        JPanel compon = new JPanel(new FlowLayout(1));
        TitledBorder titled2 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), "animation");
        compon.setBorder(titled2);
        compon.setBackground(Color.white);
        anim = new Animation();
        compon.add(anim);
        JPanel buttons = new JPanel(new BorderLayout());
        this.playbutton = new JButton("Play");
        this.playbutton.setPreferredSize(new Dimension(150, 30));
        this.playbutton.setAlignmentX(0.0f);
        this.playbutton.addActionListener(this);
        buttons.add((Component)this.playbutton, "West");
        this.stopbutton = new JButton("Stop");
        this.stopbutton.setPreferredSize(new Dimension(150, 30));
        this.stopbutton.setAlignmentX(1.0f);
        this.stopbutton.addActionListener(this);
        buttons.add((Component)this.stopbutton, "East");
        compon.setPreferredSize(new Dimension(850, 700));
        compon.add((Component)buttons, "South");
        this.MainFrame.getContentPane().add((Component)compon, "East");
    }

    public void initPanelData() {
        JPanel panelDate = new JPanel();
        panelDate.setLayout(new FlowLayout(1));
        panelDate.setBackground(Color.white);
        panelDate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), "input data"));
        panelDate.setPreferredSize(new Dimension(800, 80));
        Font font = new Font("Verdana", 0, 14);
        JTextArea txtA = new JTextArea("Day");
        txtA.setFont(font);
        txtA.setEditable(false);
        panelDate.add(txtA);
        this.GetTxtDay = new JTextField("", 5);
        this.GetTxtDay.setFont(font);
        this.GetTxtDay.setAlignmentX(1.0f);
        this.GetTxtDay.setEditable(true);
        panelDate.add(this.GetTxtDay);
        txtA = new JTextArea("Month");
        txtA.setFont(font);
        txtA.setEditable(false);
        panelDate.add(txtA);
        this.GetTxtMonth = new JTextField("", 5);
        this.GetTxtMonth.setFont(font);
        this.GetTxtMonth.setEditable(true);
        panelDate.add(this.GetTxtMonth);
        txtA = new JTextArea("Year");
        txtA.setFont(font);
        txtA.setEditable(false);
        panelDate.add(txtA);
        this.GetTxtYear = new JTextField("", 5);
        this.GetTxtYear.setFont(font);
        this.GetTxtYear.setEditable(true);
        panelDate.add(this.GetTxtYear);
        this.buttonCalc = new JButton("Calculate");
        this.buttonCalc.setPreferredSize(new Dimension(100, 30));
        this.buttonCalc.setAlignmentX(0.5f);
        this.buttonCalc.addActionListener(this);
        panelDate.add(this.buttonCalc);
        this.txtError = new JTextArea("");
        Font font3 = new Font("Verdana", 2, 10);
        this.txtError.setFont(font3);
        this.txtError.setForeground(Color.RED);
        this.txtError.setEditable(false);
        panelDate.add((Component)this.txtError, "South");
        this.MainFrame.getContentPane().add((Component)panelDate, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCalc) {
            anim.stopAnimation();
            this.timer.stop();
            this.CalculateMoonPhase();
        } else if (e.getSource() == this.playbutton) {
            anim.startAnimation();
            this.timer.start();
            this.txtError.setText(" ");
            illum.setText(" ");
            date.setText(" ");
            txto.setText(" ");
            txt2line.setText(" ");
        } else if (e.getSource() == this.stopbutton) {
            anim.stopAnimation();
            this.timer.stop();
        } else {
            String txtM;
            this.counter = this.counter < Math.PI * 2 ? (this.counter += 0.0021) : this.counter + 0.0021 - Math.PI * 2;
            anim.setMoonPosition(new Vector3d(1.5 * Math.cos(this.counter), 1.5 * Math.sin(this.counter), 0.0));
            position = this.counter / (Math.PI * 2);
            String name = "images/m_";
            int num = (int)(position * 24.0 % 24.0 + 1.0);
            String index = Integer.toString(num);
            String nameFinal = String.valueOf(name) + index + ".png";
            ImageIcon icon = new ImageIcon(nameFinal);
            this.photo.setIcon(icon);
            int ind = (int)(position * 9.0 % 9.0);
            String explan = " ";
            switch (ind) {
                case 0: {
                    txtM = "NEW MOON";
                    explan = "The Moon's unilluminated side is facing the Earth. The Moon is not visible (except during a solar eclipse)";
                    break;
                }
                case 1: {
                    txtM = "WAXING CRESCENT";
                    explan = "The Moon appears to be partly but less than one-half illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 2: {
                    txtM = "FIRST QUARTER";
                    explan = "One-half of the Moon appears to be illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 3: {
                    txtM = "WAXING GIBBOUS";
                    explan = "The Moon appears to be more than one-half but not fully illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 4: {
                    txtM = "FULL MOON";
                    explan = "The Moon's illuminated side is facing the Earth. The Moon appears to be completely illuminated by direct sunlight";
                    break;
                }
                case 5: {
                    txtM = "WANING GIBBOUS";
                    explan = "The Moon appears to be more than one-half but not fully illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 6: {
                    txtM = "THIRD QUARTER";
                    explan = "One-half of the Moon appears to be illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 7: {
                    txtM = "WANING CRESCENT";
                    explan = "The Moon appears to be partly but less than one-half illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 8: {
                    txtM = "DARK MOON";
                    explan = "The Moon's unilluminated side is facing the Earth. The Moon is not visible (except during a solar eclipse)";
                    break;
                }
                default: {
                    txtM = " ";
                    explan = " ";
                }
            }
            this.typeOfMoon.setText(txtM);
            this.specinfo.setText(explan);
            if (this.counter <= Math.PI) {
                double il = this.counter * 100.0 / Math.PI;
                illum.setText("Illumination: " + Double.toString(il).substring(0, 6) + " %");
            } else {
                double il = 100.0 - this.counter % Math.PI * 100.0 / Math.PI;
                illum.setText("Illumination: " + Double.toString(il).substring(0, 6) + " %");
            }
        }
    }

    public void CalculateMoonPhase() {
        boolean validData = true;
        int day = 0;
        int month = 0;
        int year = 0;
        try {
            day = Integer.parseInt(this.GetTxtDay.getText());
            if (day < 1 || day > 31) {
                validData = false;
                this.txtError.setText("not a valid 'Day' for a month");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Day' should be a number");
        }
        try {
            month = Integer.parseInt(this.GetTxtMonth.getText());
            if (month < 1 || month > 12) {
                validData = false;
                this.txtError.setText("not a valid 'Month' for a month");
            } else {
                if ((month == 4 || month == 6 || month == 9 || month == 11) && day > 30) {
                    validData = false;
                    this.txtError.setText("your month has as much 30 days ");
                }
                if (month == 2 & day > 29) {
                    validData = false;
                    this.txtError.setText("your month has as much 28 or 29 days ");
                }
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Month' should be a number");
        }
        try {
            year = Integer.parseInt(this.GetTxtYear.getText());
            if (year < 1900) {
                validData = false;
                this.txtError.setText("the 'Year' should be bigger than '1900'");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Year' should be a number");
        }
        if (validData) {
            String explan;
            String txtM;
            this.txtError.setText(" ");
            int a = (14 - month) / 12;
            int y = year + 4800 - a;
            int m = month + 12 * a - 3;
            float JDN = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
            float JD = JDN + 0.0f + 0.0f + 0.0f;
            int dayRef = 1;
            int monthRef = 1;
            int yearRef = 1900;
            int aRef = (14 - monthRef) / 12;
            int yRef = yearRef + 4800 - aRef;
            int mRef = monthRef + 12 * aRef - 3;
            float JDNRef = dayRef + (153 * mRef + 2) / 5 + 365 * yRef + yRef / 4 - yRef / 100 + yRef / 400 - 32045;
            float JDRef = JDNRef + 0.0f + 0.0f + 0.0f;
            txto.setText(Float.toString(JDRef));
            float D = JD - JDRef;
            double SidDay = 29.530588853;
            int ageMoon = (int)((double)D % SidDay);
            txt2line.setText(Integer.toString(ageMoon));
            double P = 0.5 * (1.0 - Math.cos((double)(360 * ageMoon) / SidDay));
            txto.setText(Double.toString(ageMoon));
            txt2line.setText(Double.toString(P));
            String name = "images/m_";
            int num = ageMoon * 25 / 29 % 25;
            String index = Integer.toString(num);
            String nameFinal = String.valueOf(name) + index + ".png";
            ImageIcon icon = new ImageIcon(nameFinal);
            this.photo.setIcon(icon);
            date.setText(String.valueOf(day) + " / " + month + " / " + year);
            txto.setText("Days since last new moon: " + Integer.toString(ageMoon));
            txt2line.setText("Days for the next new moon: " + Integer.toString(29 - ageMoon));
            int ind = ageMoon * 9 / 29 % 9;
            switch (ind) {
                case 0: {
                    txtM = "NEW MOON";
                    explan = "The Moon's unilluminated side is facing the Earth. The Moon is not visible (except during a solar eclipse)";
                    break;
                }
                case 1: {
                    txtM = "WAXING CRESCENT";
                    explan = "The Moon appears to be partly but less than one-half illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 2: {
                    txtM = "FIRST QUARTER";
                    explan = "One-half of the Moon appears to be illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 3: {
                    txtM = "WAXING GIBBOUS";
                    explan = "The Moon appears to be more than one-half but not fully illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is increasing";
                    break;
                }
                case 4: {
                    txtM = "FULL MOON";
                    explan = "The Moon's illuminated side is facing the Earth. The Moon appears to be completely illuminated by direct sunlight";
                    break;
                }
                case 5: {
                    txtM = "WANING GIBBOUS";
                    explan = "The Moon appears to be more than one-half but not fully illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 6: {
                    txtM = "THIRD QUARTER";
                    explan = "One-half of the Moon appears to be illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 7: {
                    txtM = "WANING CRESCENT";
                    explan = "The Moon appears to be partly but less than one-half illuminated by direct sunlight. The fraction of the Moon's disk that is illuminated is decreasing";
                    break;
                }
                case 8: {
                    txtM = "DARK MOON";
                    explan = "The Moon's unilluminated side is facing the Earth. The Moon is not visible (except during a solar eclipse)";
                    break;
                }
                default: {
                    txtM = " ";
                    explan = " ";
                }
            }
            this.typeOfMoon.setText(txtM);
            this.specinfo.setText(explan);
            this.counter = (double)ageMoon * 2.0 * Math.PI / 29.53;
            anim.setMoonPosition(new Vector3d(1.5 * Math.cos(this.counter), 1.5 * Math.sin(this.counter), 0.0));
            if (this.counter <= Math.PI) {
                double il = this.counter * 100.0 / Math.PI;
                illum.setText("Illumination: " + Double.toString(il).substring(0, 6) + " %");
            } else {
                double il = 100.0 - this.counter % Math.PI * 100.0 / Math.PI;
                illum.setText("Illumination: " + Double.toString(il).substring(0, 6) + " %");
            }
        }
    }
}

