/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.EnvelopeHandler;
import com.sun.j3d.loaders.lw3d.LwLightObject;
import com.sun.j3d.loaders.lw3d.LwsEnvelopeLightIntensity;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.LwsMotion;
import com.sun.j3d.loaders.lw3d.LwsPrimitive;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.PointLight;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class LwsLight
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Color3f color;
    int type;
    Point3f attenuation = new Point3f(1.0f, 0.0f, 0.0f);
    float spotConeAngle = (float)Math.PI;
    LwLightObject lwLight;
    LwsEnvelopeLightIntensity intensityEnvelope = null;
    Light light = null;
    static final int DIRECTIONAL = 0;
    static final int POINT = 1;
    static final int SPOT = 2;

    LwsLight(StreamTokenizer streamTokenizer, int n, float f, int n2) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(n2);
        this.debugOutput(1, "LwsLight()");
        this.color = new Color3f(1.0f, 1.0f, 1.0f);
        this.lwLight = new LwLightObject(null, 0.0f, null);
        this.parent = -1;
        this.debugOutputLn(8, "about to get LightName");
        this.getAndCheckString(streamTokenizer, "LightName");
        this.debugOutputLn(8, "about to get LightName value");
        this.objName = this.getName(streamTokenizer);
        this.debugOutputLn(8, "got LightName");
        this.skip(streamTokenizer, "ShowLight", 2);
        this.debugOutputLn(8, "got ShowLight");
        this.getAndCheckString(streamTokenizer, "LightMotion");
        this.debugOutputLn(8, "got LightMotion");
        this.motion = new LwsMotion(streamTokenizer, n, f);
        this.debugOutputLn(8, "got motions");
        while (!this.isCurrentToken(streamTokenizer, "ShowCamera") && !this.isCurrentToken(streamTokenizer, "AddLight")) {
            this.debugOutputLn(8, "currentToken = " + streamTokenizer.sval);
            if (this.isCurrentToken(streamTokenizer, "ParentObject")) {
                this.parent = (int)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "LightColor")) {
                this.color.x = (float)this.getNumber(streamTokenizer) / 255.0f;
                this.color.y = (float)this.getNumber(streamTokenizer) / 255.0f;
                this.color.z = (float)this.getNumber(streamTokenizer) / 255.0f;
                this.lwLight.setColor(this.color);
            } else if (this.isCurrentToken(streamTokenizer, "LgtIntensity")) {
                String string = this.getClass().getName();
                int n3 = string.lastIndexOf(46);
                String string2 = n3 < 0 ? "" : string.substring(0, n3) + ".";
                EnvelopeHandler envelopeHandler = new EnvelopeHandler(streamTokenizer, n, f, string2 + "LwsEnvelopeLightIntensity");
                if (envelopeHandler.hasValue) {
                    float f2 = envelopeHandler.theValue;
                    this.color.x *= f2;
                    this.color.y *= f2;
                    this.color.z *= f2;
                    this.lwLight.setIntensity(f2);
                } else {
                    this.intensityEnvelope = (LwsEnvelopeLightIntensity)envelopeHandler.theEnvelope;
                }
            } else if (this.isCurrentToken(streamTokenizer, "LightType")) {
                this.type = (int)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "Falloff")) {
                float f3 = (float)this.getNumber(streamTokenizer);
                this.attenuation.y = 1.0f / (1.0f - f3) - 1.0f;
            } else if (this.isCurrentToken(streamTokenizer, "ConeAngle")) {
                this.spotConeAngle = (float)this.getNumber(streamTokenizer) * ((float)Math.PI / 180);
            }
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
        streamTokenizer.pushBack();
    }

    int getParent() {
        return this.parent;
    }

    void createJava3dObject(int n) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        LwsFrame lwsFrame = this.motion.getFirstFrame();
        lwsFrame.setMatrix(matrix4d);
        this.debugOutputLn(2, "Light transform = " + matrix4d);
        Transform3D transform3D = new Transform3D();
        transform3D.set(matrix4d);
        this.objectTransform = new TransformGroup(transform3D);
        this.objectTransform.setCapability(18);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        switch (this.type) {
            case 0: {
                this.light = new DirectionalLight(this.color, vector3f);
                break;
            }
            case 1: {
                this.light = new PointLight(this.color, point3f, this.attenuation);
                break;
            }
            case 2: {
                this.light = new SpotLight(this.color, point3f, this.attenuation, vector3f, 2.0f * this.spotConeAngle, 0.0f);
                break;
            }
        }
        this.light.setCapability(15);
        if (this.light != null) {
            this.lwLight.setLight(this.light);
            BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
            this.light.setInfluencingBounds(boundingSphere);
            this.objectTransform.addChild(this.light);
            this.objectBehavior = new Vector();
            if (n != 0) {
                Behavior behavior = null;
                this.motion.createJava3dBehaviors(this.objectTransform);
                behavior = this.motion.getBehaviors();
                if (behavior != null) {
                    this.objectBehavior.addElement(behavior);
                }
                if (this.intensityEnvelope != null) {
                    behavior = null;
                    this.intensityEnvelope.createJava3dBehaviors(this.lwLight);
                    behavior = this.intensityEnvelope.getBehaviors();
                    if (behavior != null) {
                        this.objectBehavior.addElement(behavior);
                    }
                }
            }
        }
    }

    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    Light getLight() {
        return this.light;
    }

    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        this.debugOutputLn(2, "  LIGHT vals: ");
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

