/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DDSImage {
    private FileInputStream fis;
    private FileChannel chan;
    private ByteBuffer buf;
    private Header header;
    public static final int DDSD_CAPS = 1;
    public static final int DDSD_HEIGHT = 2;
    public static final int DDSD_WIDTH = 4;
    public static final int DDSD_PITCH = 8;
    public static final int DDSD_BACKBUFFERCOUNT = 32;
    public static final int DDSD_ZBUFFERBITDEPTH = 64;
    public static final int DDSD_ALPHABITDEPTH = 128;
    public static final int DDSD_LPSURFACE = 2048;
    public static final int DDSD_PIXELFORMAT = 4096;
    public static final int DDSD_MIPMAPCOUNT = 131072;
    public static final int DDSD_LINEARSIZE = 524288;
    public static final int DDSD_DEPTH = 0x800000;
    public static final int DDPF_ALPHAPIXELS = 1;
    public static final int DDPF_ALPHA = 2;
    public static final int DDPF_FOURCC = 4;
    public static final int DDPF_PALETTEINDEXED4 = 8;
    public static final int DDPF_PALETTEINDEXEDTO8 = 16;
    public static final int DDPF_PALETTEINDEXED8 = 32;
    public static final int DDPF_RGB = 64;
    public static final int DDPF_COMPRESSED = 128;
    public static final int DDPF_RGBTOYUV = 256;
    public static final int DDPF_YUV = 512;
    public static final int DDPF_ZBUFFER = 1024;
    public static final int DDPF_PALETTEINDEXED1 = 2048;
    public static final int DDPF_PALETTEINDEXED2 = 4096;
    public static final int DDPF_ZPIXELS = 8192;
    public static final int DDSCAPS_TEXTURE = 4096;
    public static final int DDSCAPS_MIPMAP = 0x400000;
    public static final int DDSCAPS_COMPLEX = 8;
    public static final int DDSCAPS2_CUBEMAP = 512;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEX = 1024;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEX = 2048;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEY = 4096;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEY = 8192;
    public static final int DDSCAPS2_CUBEMAP_POSITIVEZ = 16384;
    public static final int DDSCAPS2_CUBEMAP_NEGATIVEZ = 32768;
    public static final int D3DFMT_UNKNOWN = 0;
    public static final int D3DFMT_R8G8B8 = 20;
    public static final int D3DFMT_A8R8G8B8 = 21;
    public static final int D3DFMT_X8R8G8B8 = 22;
    public static final int D3DFMT_DXT1 = 827611204;
    public static final int D3DFMT_DXT2 = 844388420;
    public static final int D3DFMT_DXT3 = 861165636;
    public static final int D3DFMT_DXT4 = 877942852;
    public static final int D3DFMT_DXT5 = 894720068;
    private static final int MAGIC = 542327876;

    public static DDSImage read(String string) throws IOException {
        return DDSImage.read(new File(string));
    }

    public static DDSImage read(File file) throws IOException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromFile(file);
        return dDSImage;
    }

    public static DDSImage read(ByteBuffer byteBuffer) throws IOException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.readFromBuffer(byteBuffer);
        return dDSImage;
    }

    public void close() {
        try {
            if (this.chan != null) {
                this.chan.close();
                this.chan = null;
            }
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
            this.buf = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static DDSImage createFromData(int n, int n2, int n3, ByteBuffer[] byteBufferArray) throws IllegalArgumentException {
        DDSImage dDSImage = new DDSImage();
        dDSImage.initFromData(n, n2, n3, byteBufferArray);
        return dDSImage;
    }

    @Deprecated
    public static boolean isDDSImage(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            throw new IOException("Can not test non-destructively whether given InputStream is a DDS image");
        }
        inputStream.mark(4);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                inputStream.reset();
                return false;
            }
            n = n >>> 8 | n2 << 24;
        }
        inputStream.reset();
        return n == 542327876;
    }

    public void write(String string) throws IOException {
        this.write(new File(string));
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = IOUtil.getFileOutputStream(file, true);
        FileChannel fileChannel = fileOutputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(Header.writtenSize());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header.write(byteBuffer);
        byteBuffer.rewind();
        fileChannel.write(byteBuffer);
        this.buf.position(Header.writtenSize());
        fileChannel.write(this.buf);
        fileChannel.force(true);
        fileChannel.close();
        fileOutputStream.close();
    }

    public boolean isSurfaceDescFlagSet(int n) {
        return (this.header.flags & n) != 0;
    }

    public boolean isPixelFormatFlagSet(int n) {
        return (this.header.pfFlags & n) != 0;
    }

    public int getPixelFormat() {
        if (this.isCompressed()) {
            return this.getCompressionFormat();
        }
        if (this.isPixelFormatFlagSet(64)) {
            if (this.isPixelFormatFlagSet(1)) {
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255 && this.header.pfABitMask == -16777216) {
                    return 21;
                }
            } else {
                if (this.getDepth() == 24 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 20;
                }
                if (this.getDepth() == 32 && this.header.pfRBitMask == 0xFF0000 && this.header.pfGBitMask == 65280 && this.header.pfBBitMask == 255) {
                    return 22;
                }
            }
        }
        return 0;
    }

    public boolean isCubemap() {
        return (this.header.ddsCaps1 & 8) != 0 && (this.header.ddsCaps2 & 0x200) != 0;
    }

    public boolean isCubemapSidePresent(int n) {
        return this.isCubemap() && (this.header.ddsCaps2 & n) != 0;
    }

    public boolean isCompressed() {
        return this.isPixelFormatFlagSet(4);
    }

    public int getCompressionFormat() {
        return this.header.pfFourCC;
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public int getDepth() {
        return this.header.pfRGBBitCount;
    }

    public int getNumMipMaps() {
        if (!this.isSurfaceDescFlagSet(131072)) {
            return 0;
        }
        return this.header.mipMapCountOrAux;
    }

    public ImageInfo getMipMap(int n) {
        return this.getMipMap(0, n);
    }

    public ImageInfo getMipMap(int n, int n2) {
        if (!this.isCubemap() && n != 0) {
            throw new RuntimeException("Illegal side for 2D texture: " + n);
        }
        if (this.isCubemap() && !this.isCubemapSidePresent(n)) {
            throw new RuntimeException("Illegal side, side not present: " + n);
        }
        if (this.getNumMipMaps() > 0 && (n2 < 0 || n2 >= this.getNumMipMaps())) {
            throw new RuntimeException("Illegal mipmap number " + n2 + " (0.." + (this.getNumMipMaps() - 1) + ")");
        }
        int n3 = Header.writtenSize();
        if (this.isCubemap()) {
            n3 += this.sideShiftInBytes(n);
        }
        for (int i = 0; i < n2; ++i) {
            n3 += this.mipMapSizeInBytes(i);
        }
        this.buf.limit(n3 + this.mipMapSizeInBytes(n2));
        this.buf.position(n3);
        ByteBuffer byteBuffer = this.buf.slice();
        this.buf.position(0);
        this.buf.limit(this.buf.capacity());
        return new ImageInfo(byteBuffer, this.mipMapWidth(n2), this.mipMapHeight(n2), this.isCompressed(), this.getCompressionFormat());
    }

    public ImageInfo[] getAllMipMaps() {
        return this.getAllMipMaps(0);
    }

    public ImageInfo[] getAllMipMaps(int n) {
        int n2 = this.getNumMipMaps();
        if (n2 == 0) {
            n2 = 1;
        }
        ImageInfo[] imageInfoArray = new ImageInfo[n2];
        for (int i = 0; i < n2; ++i) {
            imageInfoArray[i] = this.getMipMap(n, i);
        }
        return imageInfoArray;
    }

    public static String getCompressionFormatName(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            char c = (char)(n & 0xFF);
            stringBuilder.append(c);
            n >>= 8;
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer allocateBlankBuffer(int n, int n2, int n3) {
        int n4 = n * n2;
        switch (n3) {
            case 33776: 
            case 33777: {
                n4 /= 2;
                break;
            }
            case 33778: 
            case 33779: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal OpenGL texture internal format " + n3);
            }
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return Buffers.newDirectByteBuffer(n4);
    }

    public void debugPrint() {
        int n;
        PrintStream printStream = System.err;
        printStream.println("Compressed texture: " + this.isCompressed());
        if (this.isCompressed()) {
            n = this.getCompressionFormat();
            String string = DDSImage.getCompressionFormatName(n);
            printStream.println("Compression format: 0x" + Integer.toHexString(n) + " (" + string + ")");
        }
        printStream.println("Width: " + this.header.width + " Height: " + this.header.height);
        printStream.println("header.pitchOrLinearSize: " + this.header.pitchOrLinearSize);
        printStream.println("header.pfRBitMask: 0x" + Integer.toHexString(this.header.pfRBitMask));
        printStream.println("header.pfGBitMask: 0x" + Integer.toHexString(this.header.pfGBitMask));
        printStream.println("header.pfBBitMask: 0x" + Integer.toHexString(this.header.pfBBitMask));
        printStream.println("SurfaceDesc flags:");
        n = 0;
        n |= this.printIfRecognized(printStream, this.header.flags, 1, "DDSD_CAPS");
        n |= this.printIfRecognized(printStream, this.header.flags, 2, "DDSD_HEIGHT");
        n |= this.printIfRecognized(printStream, this.header.flags, 4, "DDSD_WIDTH");
        n |= this.printIfRecognized(printStream, this.header.flags, 8, "DDSD_PITCH");
        n |= this.printIfRecognized(printStream, this.header.flags, 32, "DDSD_BACKBUFFERCOUNT");
        n |= this.printIfRecognized(printStream, this.header.flags, 64, "DDSD_ZBUFFERBITDEPTH");
        n |= this.printIfRecognized(printStream, this.header.flags, 128, "DDSD_ALPHABITDEPTH");
        n |= this.printIfRecognized(printStream, this.header.flags, 2048, "DDSD_LPSURFACE");
        n |= this.printIfRecognized(printStream, this.header.flags, 4096, "DDSD_PIXELFORMAT");
        n |= this.printIfRecognized(printStream, this.header.flags, 131072, "DDSD_MIPMAPCOUNT");
        n |= this.printIfRecognized(printStream, this.header.flags, 524288, "DDSD_LINEARSIZE");
        if ((n |= this.printIfRecognized(printStream, this.header.flags, 0x800000, "DDSD_DEPTH")) == 0) {
            printStream.println("(none)");
        }
        printStream.println("Raw SurfaceDesc flags: 0x" + Integer.toHexString(this.header.flags));
        printStream.println("Pixel format flags:");
        n = 0;
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 1, "DDPF_ALPHAPIXELS");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 2, "DDPF_ALPHA");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 4, "DDPF_FOURCC");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 8, "DDPF_PALETTEINDEXED4");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 16, "DDPF_PALETTEINDEXEDTO8");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 32, "DDPF_PALETTEINDEXED8");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 64, "DDPF_RGB");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 128, "DDPF_COMPRESSED");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 256, "DDPF_RGBTOYUV");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 512, "DDPF_YUV");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 1024, "DDPF_ZBUFFER");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 2048, "DDPF_PALETTEINDEXED1");
        n |= this.printIfRecognized(printStream, this.header.pfFlags, 4096, "DDPF_PALETTEINDEXED2");
        if ((n |= this.printIfRecognized(printStream, this.header.pfFlags, 8192, "DDPF_ZPIXELS")) == 0) {
            printStream.println("(none)");
        }
        printStream.println("Raw pixel format flags: 0x" + Integer.toHexString(this.header.pfFlags));
        printStream.println("Depth: " + this.getDepth());
        printStream.println("Number of mip maps: " + this.getNumMipMaps());
        int n2 = this.getPixelFormat();
        printStream.print("Pixel format: ");
        switch (n2) {
            case 20: {
                printStream.println("D3DFMT_R8G8B8");
                break;
            }
            case 21: {
                printStream.println("D3DFMT_A8R8G8B8");
                break;
            }
            case 22: {
                printStream.println("D3DFMT_X8R8G8B8");
                break;
            }
            case 827611204: {
                printStream.println("D3DFMT_DXT1");
                break;
            }
            case 844388420: {
                printStream.println("D3DFMT_DXT2");
                break;
            }
            case 861165636: {
                printStream.println("D3DFMT_DXT3");
                break;
            }
            case 877942852: {
                printStream.println("D3DFMT_DXT4");
                break;
            }
            case 894720068: {
                printStream.println("D3DFMT_DXT5");
                break;
            }
            case 0: {
                printStream.println("D3DFMT_UNKNOWN");
                break;
            }
            default: {
                printStream.println("(unknown pixel format " + n2 + ")");
            }
        }
    }

    private DDSImage() {
    }

    private void readFromFile(File file) throws IOException {
        this.fis = new FileInputStream(file);
        this.chan = this.fis.getChannel();
        MappedByteBuffer mappedByteBuffer = this.chan.map(FileChannel.MapMode.READ_ONLY, 0L, (int)file.length());
        this.readFromBuffer(mappedByteBuffer);
    }

    private void readFromBuffer(ByteBuffer byteBuffer) throws IOException {
        this.buf = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header = new Header();
        this.header.read(byteBuffer);
        this.fixupHeader();
    }

    private void initFromData(int n, int n2, int n3, ByteBuffer[] byteBufferArray) throws IllegalArgumentException {
        int n4 = n2 * n3;
        int n5 = n2;
        boolean bl = false;
        switch (n) {
            case 20: {
                n4 *= 3;
                n5 *= 3;
                break;
            }
            case 21: {
                n4 *= 4;
                n5 *= 4;
                break;
            }
            case 22: {
                n4 *= 4;
                n5 *= 4;
                break;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                n5 = n4 = DDSImage.computeCompressedBlockSize(n2, n3, 1, n);
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("d3dFormat must be one of the known formats");
            }
        }
        int n6 = n4;
        int n7 = n2;
        int n8 = n3;
        int n9 = 0;
        for (int i = 0; i < byteBufferArray.length; ++i) {
            if (byteBufferArray[i].remaining() != n6) {
                throw new IllegalArgumentException("Mipmap level " + i + " didn't match expected data size (expected " + n6 + ", got " + byteBufferArray[i].remaining() + ")");
            }
            if (n7 > 1) {
                n7 /= 2;
            }
            if (n8 > 1) {
                n8 /= 2;
            }
            n6 = DDSImage.computeBlockSize(n7, n8, 1, n);
            n9 += byteBufferArray[i].remaining();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n9 += Header.writtenSize());
        byteBuffer.position(Header.writtenSize());
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBuffer.put(byteBufferArray[i]);
        }
        this.buf = byteBuffer;
        this.header = new Header();
        this.header.size = Header.size();
        this.header.flags = 4103;
        if (byteBufferArray.length > 1) {
            this.header.flags |= 0x20000;
            this.header.mipMapCountOrAux = byteBufferArray.length;
        }
        this.header.width = n2;
        this.header.height = n3;
        if (bl) {
            this.header.flags |= 0x80000;
            this.header.pfFlags |= 4;
            this.header.pfFourCC = n;
        } else {
            this.header.flags |= 8;
            this.header.pfFlags |= 0x40;
            switch (n) {
                case 20: {
                    this.header.pfRGBBitCount = 24;
                    break;
                }
                case 21: {
                    this.header.pfRGBBitCount = 32;
                    this.header.pfFlags |= 1;
                    break;
                }
                case 22: {
                    this.header.pfRGBBitCount = 32;
                }
            }
            this.header.pfRBitMask = 0xFF0000;
            this.header.pfGBitMask = 65280;
            this.header.pfBBitMask = 255;
            if (n == 21) {
                this.header.pfABitMask = -16777216;
            }
        }
        this.header.pitchOrLinearSize = n5;
        this.header.pfSize = Header.pfSize();
    }

    private void fixupHeader() {
        if (this.isCompressed() && !this.isSurfaceDescFlagSet(524288)) {
            int n = this.header.backBufferCountOrDepth;
            if (n == 0) {
                n = 1;
            }
            this.header.pitchOrLinearSize = DDSImage.computeCompressedBlockSize(this.getWidth(), this.getHeight(), n, this.getCompressionFormat());
            this.header.flags |= 0x80000;
        }
    }

    private static int computeCompressedBlockSize(int n, int n2, int n3, int n4) {
        int n5 = (n + 3) / 4 * ((n2 + 3) / 4) * ((n3 + 3) / 4);
        switch (n4) {
            case 827611204: {
                n5 *= 8;
                break;
            }
            default: {
                n5 *= 16;
            }
        }
        return n5;
    }

    private static int computeBlockSize(int n, int n2, int n3, int n4) {
        int n5;
        switch (n4) {
            case 20: {
                n5 = n * n2 * 3;
                break;
            }
            case 21: 
            case 22: {
                n5 = n * n2 * 4;
                break;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: {
                n5 = DDSImage.computeCompressedBlockSize(n, n2, 1, n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("d3dFormat must be one of the known formats");
            }
        }
        return n5;
    }

    private int mipMapWidth(int n) {
        int n2 = this.getWidth();
        for (int i = 0; i < n; ++i) {
            n2 >>= 1;
        }
        return Math.max(n2, 1);
    }

    private int mipMapHeight(int n) {
        int n2 = this.getHeight();
        for (int i = 0; i < n; ++i) {
            n2 >>= 1;
        }
        return Math.max(n2, 1);
    }

    private int mipMapSizeInBytes(int n) {
        int n2 = this.mipMapWidth(n);
        int n3 = this.mipMapHeight(n);
        if (this.isCompressed()) {
            int n4 = this.getCompressionFormat() == 827611204 ? 8 : 16;
            return (n2 + 3) / 4 * ((n3 + 3) / 4) * n4;
        }
        return n2 * n3 * (this.getDepth() / 8);
    }

    private int sideSizeInBytes() {
        int n = this.getNumMipMaps();
        if (n == 0) {
            n = 1;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.mipMapSizeInBytes(i);
        }
        return n2;
    }

    private int sideShiftInBytes(int n) {
        int[] nArray = new int[]{1024, 2048, 4096, 8192, 16384, 32768};
        int n2 = 0;
        int n3 = this.sideSizeInBytes();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if ((n4 & n) != 0) {
                return n2;
            }
            n2 += n3;
        }
        throw new RuntimeException("Illegal side: " + n);
    }

    private boolean printIfRecognized(PrintStream printStream, int n, int n2, String string) {
        if ((n & n2) != 0) {
            printStream.println(string);
            return true;
        }
        return false;
    }

    static class Header {
        int size;
        int flags;
        int height;
        int width;
        int pitchOrLinearSize;
        int backBufferCountOrDepth;
        int mipMapCountOrAux;
        int alphaBitDepth;
        int reserved1;
        int surface;
        int colorSpaceLowValue;
        int colorSpaceHighValue;
        int destBltColorSpaceLowValue;
        int destBltColorSpaceHighValue;
        int srcOverlayColorSpaceLowValue;
        int srcOverlayColorSpaceHighValue;
        int srcBltColorSpaceLowValue;
        int srcBltColorSpaceHighValue;
        int pfSize;
        int pfFlags;
        int pfFourCC;
        int pfRGBBitCount;
        int pfRBitMask;
        int pfGBitMask;
        int pfBBitMask;
        int pfABitMask;
        int ddsCaps1;
        int ddsCaps2;
        int ddsCapsReserved1;
        int ddsCapsReserved2;
        int textureStage;

        Header() {
        }

        void read(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getInt();
            if (n != 542327876) {
                throw new IOException("Incorrect magic number 0x" + Integer.toHexString(n) + " (expected " + 542327876 + ")");
            }
            this.size = byteBuffer.getInt();
            this.flags = byteBuffer.getInt();
            this.height = byteBuffer.getInt();
            this.width = byteBuffer.getInt();
            this.pitchOrLinearSize = byteBuffer.getInt();
            this.backBufferCountOrDepth = byteBuffer.getInt();
            this.mipMapCountOrAux = byteBuffer.getInt();
            this.alphaBitDepth = byteBuffer.getInt();
            this.reserved1 = byteBuffer.getInt();
            this.surface = byteBuffer.getInt();
            this.colorSpaceLowValue = byteBuffer.getInt();
            this.colorSpaceHighValue = byteBuffer.getInt();
            this.destBltColorSpaceLowValue = byteBuffer.getInt();
            this.destBltColorSpaceHighValue = byteBuffer.getInt();
            this.srcOverlayColorSpaceLowValue = byteBuffer.getInt();
            this.srcOverlayColorSpaceHighValue = byteBuffer.getInt();
            this.srcBltColorSpaceLowValue = byteBuffer.getInt();
            this.srcBltColorSpaceHighValue = byteBuffer.getInt();
            this.pfSize = byteBuffer.getInt();
            this.pfFlags = byteBuffer.getInt();
            this.pfFourCC = byteBuffer.getInt();
            this.pfRGBBitCount = byteBuffer.getInt();
            this.pfRBitMask = byteBuffer.getInt();
            this.pfGBitMask = byteBuffer.getInt();
            this.pfBBitMask = byteBuffer.getInt();
            this.pfABitMask = byteBuffer.getInt();
            this.ddsCaps1 = byteBuffer.getInt();
            this.ddsCaps2 = byteBuffer.getInt();
            this.ddsCapsReserved1 = byteBuffer.getInt();
            this.ddsCapsReserved2 = byteBuffer.getInt();
            this.textureStage = byteBuffer.getInt();
        }

        void write(ByteBuffer byteBuffer) {
            byteBuffer.putInt(542327876);
            byteBuffer.putInt(this.size);
            byteBuffer.putInt(this.flags);
            byteBuffer.putInt(this.height);
            byteBuffer.putInt(this.width);
            byteBuffer.putInt(this.pitchOrLinearSize);
            byteBuffer.putInt(this.backBufferCountOrDepth);
            byteBuffer.putInt(this.mipMapCountOrAux);
            byteBuffer.putInt(this.alphaBitDepth);
            byteBuffer.putInt(this.reserved1);
            byteBuffer.putInt(this.surface);
            byteBuffer.putInt(this.colorSpaceLowValue);
            byteBuffer.putInt(this.colorSpaceHighValue);
            byteBuffer.putInt(this.destBltColorSpaceLowValue);
            byteBuffer.putInt(this.destBltColorSpaceHighValue);
            byteBuffer.putInt(this.srcOverlayColorSpaceLowValue);
            byteBuffer.putInt(this.srcOverlayColorSpaceHighValue);
            byteBuffer.putInt(this.srcBltColorSpaceLowValue);
            byteBuffer.putInt(this.srcBltColorSpaceHighValue);
            byteBuffer.putInt(this.pfSize);
            byteBuffer.putInt(this.pfFlags);
            byteBuffer.putInt(this.pfFourCC);
            byteBuffer.putInt(this.pfRGBBitCount);
            byteBuffer.putInt(this.pfRBitMask);
            byteBuffer.putInt(this.pfGBitMask);
            byteBuffer.putInt(this.pfBBitMask);
            byteBuffer.putInt(this.pfABitMask);
            byteBuffer.putInt(this.ddsCaps1);
            byteBuffer.putInt(this.ddsCaps2);
            byteBuffer.putInt(this.ddsCapsReserved1);
            byteBuffer.putInt(this.ddsCapsReserved2);
            byteBuffer.putInt(this.textureStage);
        }

        private static int size() {
            return 124;
        }

        private static int pfSize() {
            return 32;
        }

        private static int writtenSize() {
            return 128;
        }
    }

    public static class ImageInfo {
        private final ByteBuffer data;
        private final int width;
        private final int height;
        private final boolean isCompressed;
        private final int compressionFormat;

        public ImageInfo(ByteBuffer byteBuffer, int n, int n2, boolean bl, int n3) {
            this.data = byteBuffer;
            this.width = n;
            this.height = n2;
            this.isCompressed = bl;
            this.compressionFormat = n3;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public int getCompressionFormat() {
            if (!this.isCompressed()) {
                throw new RuntimeException("Should not call unless compressed");
            }
            return this.compressionFormat;
        }
    }
}

