/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus;

import java.util.ArrayList;
import java.util.List;
import ro.licj.magnus.Mobile;
import ro.licj.magnus.Renderer;
import ro.licj.magnus.Timer;
import ro.licj.magnus.Trajectory;
import ro.licj.magnus.ui.ColorGenerator;
import ro.licj.magnus.util.Point;
import ro.licj.magnus.util.Vector;

public class Game {
    private static final double GROUND_Y = 1.0;
    private static final Point INITIAL_BALL_POSITION = new Point(1.0, 1.12);
    private static final float MAX_GROUND_X = 1000.0f;
    private static final double MAGNUS_COEFFICIENT = 0.006;
    private static double dragCoefficient = 0.142;
    private static Game instance = new Game();
    private final Object ballLock = new Object();
    private final Object trajectoriesLock = new Object();
    private Renderer renderer = Renderer.getInstance();
    private Mobile ball = new Mobile(new Point(INITIAL_BALL_POSITION), 0.45, new Vector(0.23, 0.23));
    private boolean gameOver = false;
    private List<Trajectory> trajectories = new ArrayList<Trajectory>();
    private Trajectory currentTrajectory;

    private Game() {
    }

    public static Game getInstance() {
        return instance;
    }

    public static Point getInitialBallPosition() {
        return INITIAL_BALL_POSITION;
    }

    public static void main(String[] args) {
        Game.getInstance().run();
    }

    public static double getGroundY() {
        return 1.0;
    }

    public static float getMaxGroundX() {
        return 1000.0f;
    }

    public Object getBallLock() {
        return this.ballLock;
    }

    public Object getTrajectoriesLock() {
        return this.trajectoriesLock;
    }

    public void run() {
        this.currentTrajectory = new Trajectory(ColorGenerator.getInstance().next());
        try {
            this.renderer.init(this.ball, this.trajectories);
            this.restart();
            this.loop();
        }
        catch (Exception ex) {
            System.out.println("An error has occured: " + ex.toString());
            ex.printStackTrace();
        }
    }

    private void loop() {
        Timer timer = new Timer();
        while (!this.renderer.shouldClose()) {
            while (timer.shouldUpdateGame()) {
                timer.update();
                this.update();
            }
            this.renderer.draw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.renderer.shouldRestart()) {
            this.restart();
            this.renderer.setSpeedX(0.0);
            this.renderer.setSpeedY(0.0);
            this.renderer.setMagnusForce(0.0);
            this.renderer.refreshInformationPanel();
            this.renderer.resetRestartFlag();
            this.renderer.stop();
        }
        if (this.renderer.shouldClearTrajectories()) {
            this.clearTrajectories();
            this.renderer.resetClearTrajectoriesFlag();
        }
        if (this.renderer.hasStarted()) {
            if (!this.gameOver) {
                Object object = this.ballLock;
                synchronized (object) {
                    double dy;
                    Vector gravitationalForce = new Vector(0.0, -9.81 * this.ball.getMass());
                    Vector frictionForce = Vector.product(-dragCoefficient, this.ball.getSpeed());
                    Vector magnusForceTmp = Vector.product(0.006 * this.ball.getFrequency(), this.ball.getSpeed());
                    Vector magnusForce = new Vector(-magnusForceTmp.y, magnusForceTmp.x);
                    this.renderer.setSpeedX(this.ball.getSpeed().x);
                    this.renderer.setSpeedY(this.ball.getSpeed().y);
                    this.renderer.setMagnusForce(magnusForce.length());
                    this.renderer.refreshInformationPanel();
                    this.ball.applyForce(Vector.sum(Vector.sum(gravitationalForce, frictionForce), magnusForce));
                    this.ball.update();
                    if (this.ball.getPosition().x <= 0.0) {
                        this.gameOver = true;
                    }
                    if ((dy = this.ball.getPosition().y - this.ball.getSize().y / 2.0 - 1.0) <= 0.0) {
                        double t = dy / this.ball.getSpeed().y;
                        double dx = t * this.ball.getSpeed().x;
                        Point newPosition = this.ball.getPosition();
                        newPosition.x -= dx;
                        newPosition.y -= dy;
                        this.ball.setPosition(newPosition);
                        this.gameOver = true;
                    }
                    this.currentTrajectory.addPoint(this.ball.getPosition());
                    this.renderer.getTrajectoriesTableModel().refreshCell(this.trajectories.size() - 1, 1);
                    this.renderer.getTrajectoriesTableModel().refreshCell(this.trajectories.size() - 1, 2);
                }
            }
        } else {
            double initialSpeedX = this.renderer.getInitialSpeed() * Math.cos(this.renderer.getInitialDirection());
            double initialSpeedY = this.renderer.getInitialSpeed() * Math.sin(this.renderer.getInitialDirection());
            dragCoefficient = this.renderer.getDragCoefficient();
            Object object = this.ballLock;
            synchronized (object) {
                this.ball.setSpeed(new Vector(initialSpeedX, initialSpeedY));
                this.ball.setFrequency(this.renderer.getFrequency());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTrajectories() {
        Object object = this.trajectoriesLock;
        synchronized (object) {
            this.trajectories.clear();
        }
        this.renderer.getTrajectoriesTableModel().removeAllElements();
        this.currentTrajectory = new Trajectory(ColorGenerator.getInstance().current());
        if (!this.gameOver) {
            this.currentTrajectory.addPoint(this.ball.getPosition());
            object = this.trajectoriesLock;
            synchronized (object) {
                this.trajectories.add(this.currentTrajectory);
            }
            this.renderer.getTrajectoriesTableModel().addElement(this.currentTrajectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        this.currentTrajectory = new Trajectory(ColorGenerator.getInstance().next());
        this.gameOver = false;
        this.ball.setPosition(new Point(INITIAL_BALL_POSITION));
        this.currentTrajectory.addPoint(this.ball.getPosition());
        Object object = this.trajectoriesLock;
        synchronized (object) {
            this.trajectories.add(this.currentTrajectory);
        }
        this.renderer.getTrajectoriesTableModel().addElement(this.currentTrajectory);
    }
}

