/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import ro.licj.magnus.Game;
import ro.licj.magnus.Mobile;
import ro.licj.magnus.Trajectory;
import ro.licj.magnus.ui.Color;
import ro.licj.magnus.ui.GenericTableModel;
import ro.licj.magnus.ui.TrajectoryColumnifier;
import ro.licj.magnus.util.Point;
import ro.licj.magnus.util.UnitConverter;

public class Renderer {
    private static final int WINDOW_WIDTH = 1024;
    private static final int WINDOW_HEIGHT = 720;
    private static final int PIXELS_PER_METER_MAX = 125;
    private static final int PIXELS_PER_METER_MIN = 5;
    private static final float BALL_POSITION_UNIFORM_MAX = 0.75f;
    private static final float BALL_POSITION_UNIFORM_MIN = -0.75f;
    private static final float CLOUD_SIZE_X_MAX = 1.0f;
    private static final float CLOUD_SIZE_Y_MAX = 0.5f;
    private static final float CLOUD_SIZE_X_MIN = 0.8f;
    private static final float CLOUD_SIZE_Y_MIN = 0.4f;
    private static int PIXELS_PER_METER = 75;
    private static int DRAWING_PANEL_WIDTH;
    private static int DRAWING_PANEL_HEIGHT;
    private static Renderer instance;
    private final JFrame window = new JFrame("Banana Kick");
    private GLJPanel drawingPanel;
    private boolean started = false;
    private Mobile ball;
    private boolean isClosed = false;
    private GLProfile glProfile;
    private Texture ballTexture;
    private Texture cloudsTexture;
    private volatile double initialSpeed;
    private volatile double initialDirection;
    private volatile boolean restart = false;
    private volatile boolean clear = false;
    private JLabel speedLabel = new JLabel("");
    private JLabel directionLabel = new JLabel("");
    private JLabel dragCoefficientLabel = new JLabel("");
    private JLabel frequencyLabel = new JLabel("");
    private float cameraX;
    private float cameraY;
    private double dragCoefficient;
    private GenericTableModel<Trajectory> trajectoriesTableModel;
    private List<Trajectory> trajectories;
    private double frequency;
    private JLabel speedXJLabel = new JLabel();
    private JLabel speedYJLabel = new JLabel();
    private JLabel magnusForceJLabel = new JLabel();
    private volatile double speedX = 0.0;
    private volatile double speedY = 0.0;
    private volatile double magnusForce = 0.0;

    private Renderer() {
    }

    public static int getDrawingPanelWidth() {
        return DRAWING_PANEL_WIDTH;
    }

    public static int getDrawingPanelHeight() {
        return DRAWING_PANEL_HEIGHT;
    }

    public static int getPixelsPerMeter() {
        return PIXELS_PER_METER;
    }

    public static Renderer getInstance() {
        return instance;
    }

    public double getDragCoefficient() {
        return this.dragCoefficient;
    }

    public void init(Mobile ball, List<Trajectory> trajectories) {
        this.ball = ball;
        this.trajectories = trajectories;
        this.window.getContentPane().add((Component)this.createTrajectoriesTablePanel(), "East");
        this.window.getContentPane().add((Component)this.createToolboxPanel(), "South");
        this.initDrawingPanel();
        this.window.getContentPane().add((Component)this.drawingPanel, "Center");
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowevent) {
                Renderer.this.window.dispose();
                Renderer.this.isClosed = true;
            }
        });
        this.window.setSize(1024, 720);
        this.window.setExtendedState(6);
        this.window.setVisible(true);
    }

    private JScrollPane createTrajectoriesTablePanel() {
        this.trajectoriesTableModel = new GenericTableModel<Trajectory>(TrajectoryColumnifier.getInstance());
        JTable trajectoriesJTable = new JTable(this.trajectoriesTableModel);
        trajectoriesJTable.setDefaultRenderer(Color.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color displayedColor = (Color)value;
                c.setBackground(new java.awt.Color(displayedColor.r, displayedColor.g, displayedColor.b));
                return c;
            }
        });
        JScrollPane panel = new JScrollPane(trajectoriesJTable);
        panel.setPreferredSize(new Dimension(150, 0));
        return panel;
    }

    private JPanel createToolboxPanel() {
        JPanel toolboxPanel = new JPanel();
        toolboxPanel.setLayout(new BoxLayout(toolboxPanel, 2));
        toolboxPanel.add(this.createInformationPanel());
        toolboxPanel.add(this.createSelectorsPanel());
        toolboxPanel.add(this.createButtonsPanel());
        return toolboxPanel;
    }

    private JPanel createInformationPanel() {
        JPanel informationPanelContainer = new JPanel(new BorderLayout());
        JPanel informationPanel = new JPanel();
        informationPanel.setBorder(new EmptyBorder(30, 0, 30, 0));
        informationPanel.setLayout(new GridLayout(3, 2, 5, 5));
        JLabel speedXTextJLabel = new JLabel("Speed X:");
        speedXTextJLabel.setHorizontalAlignment(4);
        JLabel speedYTextJLabel = new JLabel("Speed Y:");
        speedYTextJLabel.setHorizontalAlignment(4);
        JLabel magnusForceTextJLabel = new JLabel("Magnus force:");
        magnusForceTextJLabel.setHorizontalAlignment(4);
        this.refreshInformationPanel();
        informationPanel.add(speedXTextJLabel);
        informationPanel.add(this.speedXJLabel);
        informationPanel.add(speedYTextJLabel);
        informationPanel.add(this.speedYJLabel);
        informationPanel.add(magnusForceTextJLabel);
        informationPanel.add(this.magnusForceJLabel);
        informationPanelContainer.add((Component)informationPanel, "North");
        return informationPanelContainer;
    }

    public void refreshInformationPanel() {
        this.speedXJLabel.setText(String.format("%.2f m/s", this.speedX));
        this.speedYJLabel.setText(String.format("%.2f m/s", this.speedY));
        this.magnusForceJLabel.setText(String.format("%.2f N", this.magnusForce));
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.fill = 2;
        buttonConstraints.insets = new Insets(5, 5, 5, 5);
        JButton startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Renderer.this.start();
            }
        });
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonsPanel.add((Component)startButton, buttonConstraints);
        JButton restartButton = new JButton("Restart");
        restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Renderer.this.restart = true;
            }
        });
        buttonConstraints.gridx = 1;
        buttonConstraints.gridy = 0;
        buttonsPanel.add((Component)restartButton, buttonConstraints);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Renderer.this.clear = true;
            }
        });
        buttonConstraints.gridx = 2;
        buttonConstraints.gridy = 0;
        buttonsPanel.add((Component)clearButton, buttonConstraints);
        JButton zoomInButton = new JButton("Zoom in");
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Renderer.this.zoomIn();
            }
        });
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 1;
        buttonsPanel.add((Component)zoomInButton, buttonConstraints);
        JButton zoomOutButton = new JButton("Zoom out");
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Renderer.this.zoomOut();
            }
        });
        buttonConstraints.gridx = 1;
        buttonConstraints.gridy = 1;
        buttonsPanel.add((Component)zoomOutButton, buttonConstraints);
        return buttonsPanel;
    }

    private JPanel createSelectorsPanel() {
        JPanel selectorsPanel = new JPanel();
        selectorsPanel.setLayout(new BoxLayout(selectorsPanel, 2));
        this.selectedInitialSpeed(50);
        JPanel speedSelector = this.createPropertySelector("Speed", new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider speedSelector = (JSlider)e.getSource();
                Renderer.this.selectedInitialSpeed(speedSelector.getValue());
            }
        });
        speedSelector.add(this.speedLabel);
        selectorsPanel.add(speedSelector);
        this.selectedInitialDirection(50);
        JPanel directionSelector = this.createPropertySelector("Direction", new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider directionSelector = (JSlider)e.getSource();
                Renderer.this.selectedInitialDirection(directionSelector.getValue());
            }
        });
        directionSelector.add(this.directionLabel);
        selectorsPanel.add(directionSelector);
        this.selectedDragCoefficient(50);
        JPanel dragCoefficientSelector = this.createPropertySelector("Drag coefficient", new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider dragCoefficientSelector = (JSlider)e.getSource();
                Renderer.this.selectedDragCoefficient(dragCoefficientSelector.getValue());
            }
        });
        dragCoefficientSelector.add(this.dragCoefficientLabel);
        selectorsPanel.add(dragCoefficientSelector);
        this.selectedFrequency(50);
        JPanel frequencySelector = this.createPropertySelector("Frequency", new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider frequencySelector = (JSlider)e.getSource();
                Renderer.this.selectedFrequency(frequencySelector.getValue());
            }
        });
        frequencySelector.add(this.frequencyLabel);
        selectorsPanel.add(frequencySelector);
        return selectorsPanel;
    }

    private void initDrawingPanel() {
        this.glProfile = GLProfile.getDefault();
        GLCapabilities glcapabilities = new GLCapabilities(this.glProfile);
        glcapabilities.setDoubleBuffered(true);
        this.drawingPanel = new GLJPanel(glcapabilities);
        this.drawingPanel.addGLEventListener(new GLEventListener(){

            @Override
            public void reshape(GLAutoDrawable glautodrawable, int x, int y, int width, int height) {
                Renderer.this.setup(glautodrawable.getGL().getGL2(), width, height);
            }

            @Override
            public void init(GLAutoDrawable glautodrawable) {
                GL2 gl2 = glautodrawable.getGL().getGL2();
                gl2.glMatrixMode(5888);
                Renderer.this.loadTextures();
            }

            @Override
            public void dispose(GLAutoDrawable glautodrawable) {
            }

            @Override
            public void display(GLAutoDrawable glautodrawable) {
                Renderer.this.render(glautodrawable.getGL().getGL2(), glautodrawable.getSurfaceWidth(), glautodrawable.getSurfaceHeight());
                glautodrawable.swapBuffers();
            }
        });
    }

    private void zoomIn() {
        PIXELS_PER_METER = PIXELS_PER_METER + 5 <= 125 ? (PIXELS_PER_METER += 5) : 125;
        this.resetCamera();
    }

    private void zoomOut() {
        PIXELS_PER_METER = PIXELS_PER_METER - 5 >= 5 ? (PIXELS_PER_METER -= 5) : 5;
        this.resetCamera();
    }

    private void resetCamera() {
        this.cameraX = 0.0f;
        this.cameraY = 0.0f;
    }

    private void selectedInitialDirection(int selectedDirectionPercent) {
        double initialDirectionDegrees = (double)selectedDirectionPercent * 90.0 / 100.0;
        this.initialDirection = (double)selectedDirectionPercent * Math.PI / 200.0;
        this.directionLabel.setText(String.format("%.2f", initialDirectionDegrees) + " \u00b0");
    }

    private void selectedInitialSpeed(int selectedSpeedPercent) {
        this.initialSpeed = (double)selectedSpeedPercent * 34.0 / 100.0;
        this.initialSpeed += 1.0;
        this.speedLabel.setText(String.format("%.2f", this.initialSpeed) + " m/s");
    }

    private void selectedDragCoefficient(int selectedDragCoeffPercent) {
        this.dragCoefficient = (double)selectedDragCoeffPercent * 0.142 / 100.0;
        this.dragCoefficientLabel.setText(String.format("%.2f", this.dragCoefficient));
    }

    private void selectedFrequency(int frequencyPercent) {
        this.frequency = (double)frequencyPercent / 10.0;
        this.frequencyLabel.setText(String.format("%.2f", this.frequency) + " rev/s");
    }

    private void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    private void setup(GL2 gl2, int width, int height) {
        DRAWING_PANEL_WIDTH = width;
        DRAWING_PANEL_HEIGHT = height;
        gl2.glViewport(0, 0, width, height);
    }

    private void loadTextures() {
        TextureData data;
        InputStream stream;
        try {
            stream = this.getClass().getResourceAsStream("/res/football_32x32.png");
            data = TextureIO.newTextureData(this.glProfile, stream, false, "png");
            this.ballTexture = TextureIO.newTexture(data);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failed to load the ball texture!", exc);
        }
        try {
            stream = this.getClass().getResourceAsStream("/res/clouds.png");
            data = TextureIO.newTextureData(this.glProfile, stream, false, "png");
            this.cloudsTexture = TextureIO.newTexture(data);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failed to load the ball texture!", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL2 gl2, int width, int height) {
        gl2.glClearColor(0.0f, 1.0f, 1.0f, 1.0f);
        gl2.glClear(16384);
        gl2.glLoadIdentity();
        float lineWidth = (float)PIXELS_PER_METER / 25.0f;
        if (lineWidth <= 3.0f) {
            lineWidth = 3.0f;
        }
        gl2.glLineWidth(lineWidth);
        Object object = Game.getInstance().getBallLock();
        synchronized (object) {
            this.updateCameraPosition();
            this.drawClouds(gl2);
            gl2.glTranslatef(-this.cameraX, -this.cameraY, 0.0f);
            this.drawGround(gl2);
            this.drawTrajectories(gl2);
            if (!this.hasStarted()) {
                this.drawVelocityArrow(gl2);
            }
            this.drawBall(gl2);
        }
    }

    private void drawClouds(GL2 gl2) {
        gl2.glEnable(3553);
        gl2.glEnable(3042);
        gl2.glBlendFunc(770, 771);
        gl2.glTexParameteri(3553, 10240, 9729);
        gl2.glTexParameteri(3553, 10241, 9729);
        this.cloudsTexture.enable(gl2);
        this.cloudsTexture.bind(gl2);
        float size_x = 0.8f + (float)(Renderer.getPixelsPerMeter() - 5) * 0.19999999f / 120.0f;
        float size_y = (0.4f + (float)(Renderer.getPixelsPerMeter() - 5) * 0.099999994f / 120.0f) * (float)Renderer.getDrawingPanelWidth() / (float)Renderer.getDrawingPanelHeight();
        float move_based_on_zoom_x = (float)(-(Renderer.getPixelsPerMeter() - 5)) / 480.0f;
        float move_based_on_zoom_y = -move_based_on_zoom_x / 2.0f;
        float move_based_on_camera_x = -this.cameraX * 2.0f / (float)PIXELS_PER_METER;
        float move_based_on_camera_y = -this.cameraY * 2.0f / (float)PIXELS_PER_METER;
        float move_x = move_based_on_zoom_x + move_based_on_camera_x;
        float move_y = move_based_on_zoom_y + move_based_on_camera_y;
        for (int cloudNumber = 0; cloudNumber < 3; ++cloudNumber) {
            gl2.glPushMatrix();
            gl2.glTranslatef(move_x - 1.0f + size_x / 2.0f + size_x * (float)(2 - cloudNumber), move_y + 1.0f - size_y / 2.0f, 0.0f);
            gl2.glScalef(size_x / 2.0f, size_y / 2.0f, 1.0f);
            gl2.glBegin(4);
            gl2.glTexCoord2f(0.0f, 1.0f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glTexCoord2f(0.0f, 0.75f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(-1.0f, -1.0f);
            gl2.glTexCoord2f(1.0f, 0.75f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glTexCoord2f(0.0f, 1.0f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(-1.0f, 1.0f);
            gl2.glTexCoord2f(1.0f, 1.0f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(1.0f, 1.0f);
            gl2.glTexCoord2f(1.0f, 0.75f - 0.25f * (float)cloudNumber);
            gl2.glVertex2f(1.0f, -1.0f);
            gl2.glEnd();
            gl2.glPopMatrix();
        }
        gl2.glDisable(3042);
        gl2.glDisable(3553);
    }

    private void updateCameraPosition() {
        float ballY;
        float ballX = UnitConverter.positionMetersToUniformCoordinatesX(this.ball.getPosition().x);
        if (ballX - this.cameraX >= 0.75f) {
            this.cameraX = -0.75f + ballX;
        } else if (ballX - this.cameraX <= -0.75f) {
            this.cameraX = 0.75f + ballX;
        }
        if (this.cameraX <= 0.0f) {
            this.cameraX = 0.0f;
        }
        if (-this.cameraY + (ballY = UnitConverter.positionMetersToUniformCoordinatesY(this.ball.getPosition().y)) >= 0.75f) {
            this.cameraY = -0.75f + ballY;
        } else if (ballY - this.cameraY <= -0.75f) {
            this.cameraY = 0.75f + ballY;
        }
        if (this.cameraY <= 0.0f) {
            this.cameraY = 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTrajectories(GL2 gl2) {
        Object object = Game.getInstance().getTrajectoriesLock();
        synchronized (object) {
            for (Trajectory trajectory : this.trajectories) {
                this.drawTrajectory(gl2, trajectory);
            }
        }
    }

    private void drawVelocityArrow(GL2 gl2) {
        gl2.glPushMatrix();
        gl2.glColor3f(0.0f, 0.0f, 1.0f);
        double speedX = this.ball.getSpeed().x;
        double speedY = this.ball.getSpeed().y;
        double speed = this.ball.getSpeed().length();
        float uniformX = UnitConverter.metersToUniformCoordinatesX(speedX / 4.0);
        float uniformY = UnitConverter.metersToUniformCoordinatesY(speedY / 4.0);
        double speedSinA = speedY / speed;
        double speedCosA = speedX / speed;
        double sin30 = 0.5;
        double cos30 = Math.sqrt(3.0) / 2.0;
        double len = speed / 40.0;
        float dxLeft = UnitConverter.metersToUniformCoordinatesX(-len * (cos30 * speedCosA + sin30 * speedSinA));
        float dyLeft = UnitConverter.metersToUniformCoordinatesY(len * (sin30 * speedCosA - cos30 * speedSinA));
        float dxRight = UnitConverter.metersToUniformCoordinatesX(-len * (cos30 * speedCosA - sin30 * speedSinA));
        float dyRight = UnitConverter.metersToUniformCoordinatesY(-len * (sin30 * speedCosA + cos30 * speedSinA));
        gl2.glTranslatef(UnitConverter.positionMetersToUniformCoordinatesX(this.ball.getPosition().x), UnitConverter.positionMetersToUniformCoordinatesY(this.ball.getPosition().y), 0.0f);
        gl2.glBegin(1);
        gl2.glVertex2f(0.0f, 0.0f);
        gl2.glVertex2f(uniformX, uniformY);
        gl2.glVertex2f(uniformX, uniformY);
        gl2.glVertex2f(uniformX + dxLeft, uniformY + dyLeft);
        gl2.glVertex2f(uniformX, uniformY);
        gl2.glVertex2f(uniformX + dxRight, uniformY + dyRight);
        gl2.glEnd();
        gl2.glPopMatrix();
    }

    private void drawGround(GL2 gl2) {
        float groundLevel = UnitConverter.positionMetersToUniformCoordinatesY(Game.getGroundY() + (double)0.2f);
        float groundMax = UnitConverter.metersToUniformCoordinatesX(Game.getMaxGroundX());
        gl2.glColor3f(0.0f, 0.7f, 0.0f);
        gl2.glBegin(7);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glVertex2f(-1.0f, groundLevel);
        gl2.glVertex2f(-1.0f + groundMax, groundLevel);
        gl2.glVertex2f(-1.0f + groundMax, -1.0f);
        gl2.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTrajectory(GL2 gl2, Trajectory trajectory) {
        Trajectory trajectory2 = trajectory;
        synchronized (trajectory2) {
            List<Point> trajectoryPoints = trajectory.getPoints();
            if (trajectoryPoints.size() <= 1) {
                return;
            }
            int numberOfPoints = trajectoryPoints.size();
            float[] tmp = new float[2 * numberOfPoints];
            for (int i = 0; i < numberOfPoints; ++i) {
                Point point = trajectoryPoints.get(i);
                float x = UnitConverter.positionMetersToUniformCoordinatesX(point.x);
                float y = UnitConverter.positionMetersToUniformCoordinatesY(point.y);
                tmp[2 * i] = x;
                tmp[2 * i + 1] = y;
            }
            FloatBuffer pointBuffer = GLBuffers.newDirectFloatBuffer(tmp);
            gl2.glEnableClientState(32884);
            gl2.glVertexPointer(2, 5126, 0, pointBuffer);
            ShortBuffer indicesBuffer = ShortBuffer.allocate(numberOfPoints * 4 - 4);
            for (short i = 0; i < 2 * numberOfPoints - 2; i = (short)(i + 1)) {
                indicesBuffer.put(i);
                indicesBuffer.put((short)(i + 1));
            }
            indicesBuffer.flip();
            gl2.glColor3f(trajectory.getColor().r, trajectory.getColor().g, trajectory.getColor().b);
            gl2.glDrawElements(1, 2 * numberOfPoints - 2, 5123, indicesBuffer);
            gl2.glDisableClientState(32884);
        }
    }

    private void drawBall(GL2 gl2) {
        gl2.glColor3f(1.0f, 1.0f, 1.0f);
        gl2.glEnable(3553);
        gl2.glEnable(3042);
        gl2.glBlendFunc(770, 771);
        gl2.glTexParameteri(3553, 10240, 9729);
        gl2.glTexParameteri(3553, 10241, 9729);
        this.ballTexture.enable(gl2);
        this.ballTexture.bind(gl2);
        gl2.glPushMatrix();
        gl2.glTranslatef(UnitConverter.positionMetersToUniformCoordinatesX(this.ball.getPosition().x), UnitConverter.positionMetersToUniformCoordinatesY(this.ball.getPosition().y), 0.0f);
        gl2.glScalef(UnitConverter.metersToUniformCoordinatesX(this.ball.getSize().x) / 2.0f, UnitConverter.metersToUniformCoordinatesY(this.ball.getSize().y) / 2.0f, 1.0f);
        gl2.glRotatef((float)(this.ball.getAngle() * 180.0 / Math.PI), 0.0f, 0.0f, 1.0f);
        gl2.glBegin(4);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glTexCoord2f(0.0f, 0.0f);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glTexCoord2f(0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glTexCoord2f(1.0f, 1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glTexCoord2f(1.0f, 0.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glEnd();
        gl2.glPopMatrix();
        gl2.glDisable(3042);
        gl2.glDisable(3553);
    }

    public boolean shouldClose() {
        return this.isClosed;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public void draw() {
        this.drawingPanel.display();
    }

    private JPanel createPropertySelector(String propertyName, ChangeListener changeListener) {
        JPanel propertySelectorPanel = new JPanel();
        propertySelectorPanel.setLayout(new BoxLayout(propertySelectorPanel, 3));
        propertySelectorPanel.setBorder(new TitledBorder(propertyName));
        propertySelectorPanel.add(new JLabel(propertyName));
        JSlider propertySelector = new JSlider();
        propertySelector.addChangeListener(changeListener);
        propertySelectorPanel.add(propertySelector);
        return propertySelectorPanel;
    }

    public double getInitialSpeed() {
        return this.initialSpeed;
    }

    public double getInitialDirection() {
        return this.initialDirection;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public boolean shouldRestart() {
        return this.restart;
    }

    public void resetRestartFlag() {
        this.restart = false;
    }

    public boolean shouldClearTrajectories() {
        return this.clear;
    }

    public void resetClearTrajectoriesFlag() {
        this.clear = false;
    }

    public GenericTableModel<Trajectory> getTrajectoriesTableModel() {
        return this.trajectoriesTableModel;
    }

    public void setSpeedX(double speedX) {
        this.speedX = speedX;
    }

    public void setSpeedY(double speedY) {
        this.speedY = speedY;
    }

    public void setMagnusForce(double magnusForce) {
        this.magnusForce = magnusForce;
    }

    static {
        instance = new Renderer();
    }
}

