#include <Wire.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

#define OLED_RESET     4 // Reset pin # (or -1 if sharing Arduino reset pin)
// !!! Namengebung !!! für das Display mit dem Objektnamen "display"
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void setup()
{
  DDRB = 63;
  DDRC = 0;
  DDRD = 255;
  PORTD = 0;
  PORTB = 0;

  // 3,3 V einschalten an I2C-HEX-Adresse 3C
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);

  /*
    Serial.begin(9600);
    // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
    if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Address 0x3C for 128x32
      Serial.println(F("SSD1306 allocation failed"));
      for (;;); // Don't proceed, loop forever
    }
    Serial.end();
  */
}

void loop()
{
  int taster = 0;
  int potioben = 0;
  int potiunten = 0;
  int d[10] = {0, 1, 2, 4, 8, 16, 32, 64, 128, 255};
  int w[10] = {0, 16, 32, 48, 34, 50, 35, 51,   0,  51};
  int count = 0;
  int pos = 0;

  display.clearDisplay();
  display.display();      // WICHTIG !!!!!!
  display.setTextSize(1); // kleine Schrift
  display.setTextColor(SSD1306_WHITE); // Schriftfarbe

  //START
  display.setTextSize(3);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(30, 20);
  display.println("Moin");
  display.display();
  delay(1000);
  display.invertDisplay(true);
  delay(1000);
  display.invertDisplay(false);
  delay(1000);
  display.clearDisplay();



  while (1)
  {
    // LESEN
    taster = PINC & 0x0f;
    potioben = analogRead(A6);
    potiunten = analogRead(A7);

    // SCHREIBEN
    display.setTextSize(1);
    display.clearDisplay();
    if (taster == 1)
    {
      display.setCursor(60, 50);            // Start at top-left corner
      display.println("S0");
    }
    if (taster == 2)
    {
      display.setCursor(110, 30);            // Start at top-left corner
      display.println("S1");
    }
    if (taster == 4)
    {
      display.setCursor(10, 30);            // Start at top-left corner
      display.println("S2");
    }
    if (taster == 8)
    {
      display.setCursor(60, 10);            // Start at top-left corner
      display.println("S3");
    }
    // potioben
    display.setCursor(50, 20);            // Start at top-left corner
    display.println(potioben);
    analogWrite(10, (potioben / 4));
    // potiunten
    display.setCursor(70, 40);            // Start at top-left corner
    display.println(potiunten);
    analogWrite(11, map(potiunten, 0, 1024, 0, 255));
    display.display();

    // Ausgabe auf die Ports
    count++;
    if (count >= 50)
    {
      count = 0;
      PORTD = d[pos];
      PORTB = w[pos];
      pos++;
      if (pos == 10)pos = 0;
    }
    delay(1);
  }
}
